/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.services.ResolvingJavaTypeContext;
import com.redhat.qute.services.inlayhint.InlayHintASTVistor;
import com.redhat.qute.settings.QuteInlayHintSettings;
import com.redhat.qute.settings.SharedSettings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteInlayHint {
    private static final Logger LOGGER = Logger.getLogger(QuteInlayHint.class.getName());
    private static CompletableFuture<List<InlayHint>> NO_INLAY_HINT = CompletableFuture.completedFuture(Collections.emptyList());
    private final QuteProjectRegistry projectRegistry;

    public QuteInlayHint(QuteProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    public CompletableFuture<List<InlayHint>> getInlayHint(Template template, Range range, SharedSettings sharedSettings, ResolvingJavaTypeContext resolvingJavaTypeContext, CancelChecker cancelChecker) {
        QuteInlayHintSettings settings;
        QuteInlayHintSettings inlayHintSettings = sharedSettings.getInlayHintSettings();
        QuteInlayHintSettings quteInlayHintSettings = settings = inlayHintSettings != null ? inlayHintSettings : QuteInlayHintSettings.DEFAULT;
        if (!settings.isEnabled()) {
            return NO_INLAY_HINT;
        }
        return this.projectRegistry.getDataModelTemplate(template).thenApply(templateDataModel -> {
            int startOffset = -1;
            int endOffset = -1;
            if (range != null) {
                try {
                    startOffset = template.offsetAt(range.getStart());
                    endOffset = template.offsetAt(range.getEnd());
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "Error while getting offsets view port range", e);
                }
            }
            cancelChecker.checkCanceled();
            InlayHintASTVistor visitor = new InlayHintASTVistor(startOffset, endOffset, sharedSettings, resolvingJavaTypeContext, cancelChecker);
            template.accept(visitor);
            cancelChecker.checkCanceled();
            return visitor.getInlayHints();
        });
    }
}

