/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.ls.api.QuteTemplateJavaTextEditProvider;
import com.redhat.qute.ls.commons.snippets.Snippet;
import com.redhat.qute.ls.commons.snippets.SnippetRegistry;
import com.redhat.qute.ls.commons.snippets.SnippetRegistryProvider;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.services.QuteCodeActions;
import com.redhat.qute.services.QuteCodeLens;
import com.redhat.qute.services.QuteCompletions;
import com.redhat.qute.services.QuteDefinition;
import com.redhat.qute.services.QuteDiagnostics;
import com.redhat.qute.services.QuteDocumentLink;
import com.redhat.qute.services.QuteHighlighting;
import com.redhat.qute.services.QuteHover;
import com.redhat.qute.services.QuteInlayHint;
import com.redhat.qute.services.QuteLinkedEditing;
import com.redhat.qute.services.QuteReference;
import com.redhat.qute.services.QuteRename;
import com.redhat.qute.services.QuteSymbolsProvider;
import com.redhat.qute.services.ResolvingJavaTypeContext;
import com.redhat.qute.services.codeactions.QuteTemplateCodeActionResolvers;
import com.redhat.qute.settings.QuteCompletionSettings;
import com.redhat.qute.settings.QuteFormattingSettings;
import com.redhat.qute.settings.QuteNativeSettings;
import com.redhat.qute.settings.QuteValidationSettings;
import com.redhat.qute.settings.SharedSettings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteLanguageService
implements SnippetRegistryProvider<Snippet> {
    private final QuteCodeActions codeActions;
    private final QuteCodeLens codeLens;
    private final QuteCompletions completions;
    private final QuteDefinition definition;
    private final QuteDiagnostics diagnostics;
    private final QuteDocumentLink documentLink;
    private final QuteHighlighting highlighting;
    private final QuteHover hover;
    private final QuteInlayHint inlayHint;
    private final QuteLinkedEditing linkedEditing;
    private final QuteReference reference;
    private final QuteRename rename;
    private final QuteSymbolsProvider symbolsProvider;
    private final QuteTemplateCodeActionResolvers codeActionResolvers;
    private SnippetRegistry<Snippet> coreTagSnippetRegistry;

    public QuteLanguageService(QuteProjectRegistry projectRegistry) {
        this.codeActions = new QuteCodeActions(projectRegistry);
        this.codeLens = new QuteCodeLens(projectRegistry);
        this.completions = new QuteCompletions(projectRegistry, this);
        this.definition = new QuteDefinition();
        this.diagnostics = new QuteDiagnostics(projectRegistry);
        this.documentLink = new QuteDocumentLink();
        this.highlighting = new QuteHighlighting();
        this.hover = new QuteHover(this);
        this.inlayHint = new QuteInlayHint(projectRegistry);
        this.linkedEditing = new QuteLinkedEditing();
        this.reference = new QuteReference();
        this.rename = new QuteRename();
        this.symbolsProvider = new QuteSymbolsProvider();
        this.codeActionResolvers = new QuteTemplateCodeActionResolvers();
    }

    public CompletableFuture<List<CodeAction>> doCodeActions(Template template, CodeActionContext context, QuteTemplateJavaTextEditProvider javaTextEditProvider, Range range, SharedSettings sharedSettings) {
        return this.codeActions.doCodeActions(template, context, range, javaTextEditProvider, sharedSettings);
    }

    public CompletableFuture<List<? extends CodeLens>> getCodeLens(Template template, SharedSettings settings, CancelChecker cancelChecker) {
        return this.codeLens.getCodelens(template, settings, cancelChecker);
    }

    public CompletableFuture<CompletionList> doComplete(Template template, Position position, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, QuteNativeSettings nativeImagesSettings, CancelChecker cancelChecker) {
        return this.completions.doComplete(template, position, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
    }

    public CompletableFuture<List<? extends LocationLink>> findDefinition(Template template, Position position, CancelChecker cancelChecker) {
        return this.definition.findDefinition(template, position, cancelChecker);
    }

    public List<Diagnostic> doDiagnostics(Template template, QuteValidationSettings validationSettings, QuteNativeSettings nativeImagesSettings, ResolvingJavaTypeContext resolvingJavaTypeFutures, CancelChecker cancelChecker) {
        return this.diagnostics.doDiagnostics(template, validationSettings, nativeImagesSettings, resolvingJavaTypeFutures, cancelChecker);
    }

    public CompletableFuture<List<DocumentLink>> findDocumentLinks(Template template, CancelChecker cancelChecker) {
        return this.documentLink.findDocumentLinks(template, cancelChecker);
    }

    public List<DocumentHighlight> findDocumentHighlights(Template template, Position position, CancelChecker cancelChecker) {
        return this.highlighting.findDocumentHighlights(template, position, cancelChecker);
    }

    public CompletableFuture<Hover> doHover(Template template, Position position, SharedSettings sharedSettings, CancelChecker cancelChecker) {
        return this.hover.doHover(template, position, sharedSettings, cancelChecker);
    }

    public CompletableFuture<List<InlayHint>> getInlayHint(Template template, Range range, SharedSettings sharedSettings, ResolvingJavaTypeContext resolvingJavaTypeContext, CancelChecker cancelChecker) {
        return this.inlayHint.getInlayHint(template, range, sharedSettings, resolvingJavaTypeContext, cancelChecker);
    }

    public LinkedEditingRanges findLinkedEditingRanges(Template template, Position position, CancelChecker cancelChecker) {
        return this.linkedEditing.findLinkedEditingRanges(template, position, cancelChecker);
    }

    public List<? extends Location> findReferences(Template template, Position position, ReferenceContext context, CancelChecker cancelChecker) {
        return this.reference.findReferences(template, position, context, cancelChecker);
    }

    public WorkspaceEdit doRename(Template template, Position position, String newText, CancelChecker cancelChecker) {
        return this.rename.doRename(template, position, newText, cancelChecker);
    }

    public List<DocumentSymbol> findDocumentSymbols(Template template, CancelChecker cancelChecker) {
        return this.symbolsProvider.findDocumentSymbols(template, cancelChecker);
    }

    public List<SymbolInformation> findSymbolInformations(Template template, CancelChecker cancelChecker) {
        return this.symbolsProvider.findSymbolInformations(template, cancelChecker);
    }

    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction unresolved, QuteTemplateJavaTextEditProvider javaTextEditProvider) {
        return this.codeActionResolvers.resolveCodeAction(unresolved, javaTextEditProvider);
    }

    @Override
    public SnippetRegistry<Snippet> getSnippetRegistry() {
        if (this.coreTagSnippetRegistry == null) {
            this.loadCoreTagSnippetRegistry();
        }
        return this.coreTagSnippetRegistry;
    }

    private synchronized void loadCoreTagSnippetRegistry() {
        if (this.coreTagSnippetRegistry != null) {
            return;
        }
        this.coreTagSnippetRegistry = new SnippetRegistry();
    }
}

