/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.utils.QutePositionUtility;
import com.redhat.qute.utils.QuteSearchUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class QuteLinkedEditing {
    private static final Logger LOGGER = Logger.getLogger(QuteLinkedEditing.class.getName());

    QuteLinkedEditing() {
    }

    public LinkedEditingRanges findLinkedEditingRanges(Template template, Position position, CancelChecker cancelChecker) {
        try {
            int offset = template.offsetAt(position);
            Node node = template.findNodeAt(offset);
            if (node == null) {
                return null;
            }
            node = QutePositionUtility.findBestNode(offset, node);
            ArrayList ranges = new ArrayList();
            QuteSearchUtils.searchReferencedObjects(node, offset, (n, range) -> ranges.add(range), true, cancelChecker);
            if (ranges.size() <= 1) {
                return null;
            }
            return new LinkedEditingRanges(ranges);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In QuteLinkedEditing the client provided Position is at a BadLocation", e);
            return null;
        }
    }
}

