/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class QuteSymbolsProvider {
    QuteSymbolsProvider() {
    }

    public List<DocumentSymbol> findDocumentSymbols(Template template, CancelChecker cancelChecker) {
        ArrayList<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        for (int i = 0; i < template.getChildCount(); ++i) {
            Node child = template.getChild(i);
            this.findDocumentSymbols(child, symbols, template, cancelChecker);
        }
        return symbols;
    }

    private void findDocumentSymbols(Node node, List<DocumentSymbol> symbols, Template template, CancelChecker cancelChecker) {
        Range selectionRange;
        if (!this.isNodeSymbol(node)) {
            return;
        }
        cancelChecker.checkCanceled();
        String name = this.nodeToName(node);
        Range range = selectionRange = QuteSymbolsProvider.getSymbolRange(node);
        ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
        DocumentSymbol symbol = new DocumentSymbol(name, this.getSymbolKind(node), range, selectionRange, null, children);
        symbols.add(symbol);
        if (node.getChildCount() > 0) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Node child = node.getChild(i);
                this.findDocumentSymbols(child, children, template, cancelChecker);
            }
        }
    }

    private SymbolKind getSymbolKind(Node node) {
        switch (node.getKind()) {
            case Text: {
                return SymbolKind.Constant;
            }
            case Expression: {
                return SymbolKind.Function;
            }
            case Comment: {
                return SymbolKind.Struct;
            }
            case Section: {
                return SymbolKind.Constructor;
            }
        }
        return SymbolKind.Field;
    }

    private String nodeToName(Node node) {
        if (node.getKind() == NodeKind.Section) {
            Section section = (Section)node;
            return "Section#" + section.getTag();
        }
        return node.getClass().getSimpleName();
    }

    private static Range getSymbolRange(Node node) {
        return QutePositionUtility.createRange(node);
    }

    private boolean isNodeSymbol(Node node) {
        return true;
    }

    public List<SymbolInformation> findSymbolInformations(Template template, CancelChecker cancelChecker) {
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        return symbols;
    }
}

