/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.datamodel.ExtendedDataModelTemplate;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.diagnostics.QuteErrorCode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResolvingJavaTypeContext
extends ArrayList<CompletableFuture<?>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ResolvingJavaTypeContext.class.getName());
    private boolean projectResolved;
    private boolean dataModelTemplateResolved;
    private boolean binaryUserTagResolved;
    private Set<String> javaTypesSupportedInNativeMode;
    private final Template template;

    public ResolvingJavaTypeContext(Template template) {
        this.template = template;
        boolean bl = this.projectResolved = template.getProjectUri() != null;
        if (this.projectResolved) {
            CompletableFuture<ExtendedDataModelTemplate> f = template.getDataModelTemplate();
            this.dataModelTemplateResolved = f.isDone();
            if (!this.dataModelTemplateResolved) {
                super.add(f);
            }
            this.binaryUserTagResolved = false;
            QuteProject project = template.getProject();
            if (project != null) {
                CompletableFuture<List<UserTag>> tags = project.getBinaryUserTags();
                this.binaryUserTagResolved = tags.isDone();
                if (!this.binaryUserTagResolved) {
                    super.add(tags);
                }
            }
        }
    }

    public boolean isProjectResolved() {
        return this.projectResolved;
    }

    public boolean isDataModelTemplateResolved() {
        return this.dataModelTemplateResolved;
    }

    public boolean isBinaryUserTagResolved() {
        return this.binaryUserTagResolved;
    }

    @Override
    public boolean add(CompletableFuture<?> e) {
        if (super.contains(e)) {
            return true;
        }
        return super.add(e);
    }

    public ResolvedJavaTypeInfo resolveJavaType(String javaType, QuteProject project) {
        CompletableFuture<ResolvedJavaTypeInfo> resolvingJavaTypeFuture = project.resolveJavaType(javaType);
        ResolvedJavaTypeInfo resolvedJavaType = resolvingJavaTypeFuture.getNow(QuteCompletableFutures.RESOLVING_JAVA_TYPE);
        if (QuteCompletableFutures.isResolvingJavaType(resolvedJavaType)) {
            LOGGER.log(Level.INFO, QuteErrorCode.ResolvingJavaType.getMessage(javaType));
            this.add(resolvingJavaTypeFuture);
            return QuteCompletableFutures.RESOLVING_JAVA_TYPE;
        }
        return resolvedJavaType;
    }

    public ResolvedJavaTypeInfo resolveJavaType(Parameter parameter, QuteProject project) {
        CompletableFuture<ResolvedJavaTypeInfo> resolvingJavaTypeFuture = project.resolveJavaType(parameter);
        ResolvedJavaTypeInfo resolvedJavaType = resolvingJavaTypeFuture.getNow(QuteCompletableFutures.RESOLVING_JAVA_TYPE);
        if (QuteCompletableFutures.isResolvingJavaType(resolvedJavaType)) {
            this.add(resolvingJavaTypeFuture);
            return QuteCompletableFutures.RESOLVING_JAVA_TYPE;
        }
        return resolvedJavaType;
    }

    public Set<String> getJavaTypesSupportedInNativeMode() {
        if (this.javaTypesSupportedInNativeMode == null) {
            this.javaTypesSupportedInNativeMode = this.template.getJavaTypesSupportedInNativeMode();
        }
        return this.javaTypesSupportedInNativeMode;
    }
}

