/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.ls.commons.CodeActionFactory;
import com.redhat.qute.ls.commons.client.ConfigurationItemEdit;
import com.redhat.qute.ls.commons.client.ConfigurationItemEditType;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import com.redhat.qute.services.diagnostics.QuteErrorCode;
import com.redhat.qute.services.nativemode.JavaTypeAccessibiltyRule;
import com.redhat.qute.services.nativemode.JavaTypeFilter;
import com.redhat.qute.settings.QuteValidationSettings;
import com.redhat.qute.utils.QutePositionUtility;
import com.redhat.qute.utils.StringUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public abstract class AbstractQuteCodeAction {
    private static final String SET_IGNORE_SEVERITY_TITLE = "Ignore `{0}` problem.";
    private static final String DID_YOU_MEAN_TITLE = "Did you mean `{0}`?";

    protected void doCodeActionsForSimilarValue(Part part, String value, Template template, Set<String> existingProperties, Diagnostic diagnostic, List<CodeAction> codeActions) {
        String partName = part.getPartName();
        if (!existingProperties.contains(value) && StringUtils.isSimilar(value, partName)) {
            Range rangeValue = QutePositionUtility.createRange(part);
            CodeAction similarCodeAction = CodeActionFactory.replace(MessageFormat.format(DID_YOU_MEAN_TITLE, value), rangeValue, value, template.getTextDocument(), diagnostic);
            codeActions.add(similarCodeAction);
            existingProperties.add(value);
        }
    }

    protected static void doCodeActionToSetIgnoreSeverity(Template template, Diagnostic diagnostic, QuteErrorCode errorCode, List<CodeAction> codeActions, String severitySetting) {
        List<Diagnostic> diagnostics = Collections.singletonList(diagnostic);
        String title = MessageFormat.format(SET_IGNORE_SEVERITY_TITLE, errorCode.getCode());
        CodeAction setIgnoreSeverityQuickFix = AbstractQuteCodeAction.createConfigurationUpdateCodeAction(title, template.getUri(), severitySetting, QuteValidationSettings.Severity.ignore.name(), ConfigurationItemEditType.update, diagnostics);
        codeActions.add(setIgnoreSeverityQuickFix);
    }

    public static CodeAction createConfigurationUpdateCodeAction(String title, String scopeUri, String sectionName, Object sectionValue, ConfigurationItemEditType editType, List<Diagnostic> diagnostics) {
        ConfigurationItemEdit configItemEdit = new ConfigurationItemEdit(sectionName, editType, sectionValue);
        configItemEdit.setScopeUri(scopeUri);
        return CodeActionFactory.createCommand(title, "qute.command.configuration.update", Collections.singletonList(configItemEdit), diagnostics);
    }

    protected static boolean isIgnoreSuperclasses(ResolvedJavaTypeInfo baseType, JavaTypeAccessibiltyRule rule, JavaTypeFilter filter) {
        return filter != null && rule != null && filter.isIgnoreSuperclasses(baseType, rule);
    }

    public abstract void doCodeActions(CodeActionRequest var1, List<CompletableFuture<Void>> var2, List<CodeAction> var3);
}

