/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.ls.api.QuteTemplateJavaTextEditProvider;
import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.services.AbstractPositionRequest;
import com.redhat.qute.services.diagnostics.DiagnosticDataFactory;
import com.redhat.qute.services.diagnostics.JavaBaseTypeOfPartData;
import com.redhat.qute.settings.SharedSettings;
import com.redhat.qute.utils.QutePositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;

public class CodeActionRequest
extends AbstractPositionRequest {
    private final Template template;
    private final Diagnostic diagnostic;
    private final QuteTemplateJavaTextEditProvider javaTextEditProvider;
    private final SharedSettings sharedSettings;
    private Node coveredNode;
    private ResolvedJavaTypeInfo resolvedType;

    public CodeActionRequest(Template template, Position position, Diagnostic diagnostic, QuteTemplateJavaTextEditProvider javaTextEditProvider, SharedSettings sharedSettings) throws BadLocationException {
        super(template, position);
        this.template = template;
        this.diagnostic = diagnostic;
        this.javaTextEditProvider = javaTextEditProvider;
        this.sharedSettings = sharedSettings;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public QuteTemplateJavaTextEditProvider getTextEditProvider() {
        return this.javaTextEditProvider;
    }

    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    public Node getCoveredNode() throws BadLocationException {
        if (this.coveredNode == null) {
            int offset = this.template.offsetAt(this.diagnostic.getRange().getEnd());
            Node node = this.template.findNodeBefore(offset);
            if (node == null) {
                return null;
            }
            this.coveredNode = QutePositionUtility.findBestNode(offset, node);
        }
        return this.coveredNode;
    }

    public ResolvedJavaTypeInfo getJavaTypeOfCoveredNode() {
        if (this.resolvedType == null) {
            JavaBaseTypeOfPartData data = DiagnosticDataFactory.getJavaBaseTypeOfPartData(this.diagnostic);
            if (data == null) {
                return null;
            }
            QuteProject project = this.template.getProject();
            if (project == null) {
                return null;
            }
            String signature = data.getSignature();
            this.resolvedType = project.resolveJavaTypeSync(signature);
        }
        return this.resolvedType;
    }

    @Override
    protected Node doFindNodeAt(Template template, int offset) {
        Node node = template.findNodeBefore(offset);
        if (node == null) {
            return null;
        }
        Node coveredNodeAtOffset = QutePositionUtility.findBestNode(offset, node);
        return coveredNodeAtOffset;
    }
}

