/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.jaxrs.RestParam;
import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.CodeActionFactory;
import com.redhat.qute.ls.commons.LineIndentInfo;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.RangeOffset;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.JavaMemberResult;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.services.codeactions.AbstractQuteCodeAction;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class QuteCodeActionForMissingInputs
extends AbstractQuteCodeAction {
    private static final Logger LOGGER = Logger.getLogger(QuteCodeActionForMissingInputs.class.getName());
    private static final String DEFAULT_INDENTATION = "  ";
    private final QuteProjectRegistry projectRegistry;

    public QuteCodeActionForMissingInputs(QuteProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    @Override
    public void doCodeActions(CodeActionRequest request, List<CompletableFuture<Void>> codeActionResolveFutures, List<CodeAction> codeActions) {
        try {
            MethodPart methodPart;
            Section section;
            Template template = request.getTemplate();
            QuteProject project = template.getProject();
            if (project == null) {
                return;
            }
            Node node = request.getCoveredNode();
            if (node == null) {
                return;
            }
            Section section2 = section = node.getKind() == NodeKind.Section ? (Section)node : null;
            if (section == null) {
                return;
            }
            Diagnostic diagnostic = request.getDiagnostic();
            String projectUri = template.getProjectUri();
            int methodOffset = section.getParameters().get(0).getEnd() - 2;
            MethodPart methodPart2 = methodPart = request.doFindNodeAt(template, methodOffset) instanceof MethodPart ? (MethodPart)request.doFindNodeAt(template, methodOffset) : null;
            if (methodPart == null) {
                return;
            }
            ResolvedJavaTypeInfo baseResolvedType = request.getJavaTypeOfCoveredNode();
            JavaMemberResult result = project.findMethod(baseResolvedType, methodPart.getNamespace(), methodPart.getPartName(), new ArrayList<ResolvedJavaTypeInfo>(), this.projectRegistry.getJavaTypeFilter(projectUri, request.getSharedSettings().getNativeSettings()).isInNativeMode());
            if (result == null) {
                return;
            }
            Collection<RestParam> restParams = ((JavaMethodInfo)result.getMember()).getRestParameters();
            ArrayList<String> requiredInputNames = new ArrayList<String>();
            ArrayList<String> allInputNames = new ArrayList<String>();
            for (RestParam param : restParams) {
                if (param.isRequired()) {
                    requiredInputNames.add(param.getName());
                }
                allInputNames.add(param.getName());
            }
            Range range = QutePositionUtility.createRange(new RangeOffset(section.getStartTagCloseOffset() + 1, section.getEndTagOpenOffset()), template);
            CodeAction insertRequiredInputs = CodeActionFactory.replace("Insert required input forms", range, QuteCodeActionForMissingInputs.generateInput(template, requiredInputNames, range), template.getTextDocument(), diagnostic);
            codeActions.add(insertRequiredInputs);
            CodeAction insertAllInputs = CodeActionFactory.replace("Insert all input forms", range, QuteCodeActionForMissingInputs.generateInput(template, allInputNames, range), template.getTextDocument(), diagnostic);
            codeActions.add(insertAllInputs);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of generate missing inputs code action failed", e);
        }
    }

    private static String generateInput(Template template, List<String> inputs, Range range) throws BadLocationException {
        StringBuilder str = new StringBuilder();
        int lineNumber = range.getStart().getLine();
        LineIndentInfo indentInfo = template.lineIndentInfo(lineNumber);
        String lineDelimiter = indentInfo.getLineDelimiter();
        String whitespacesIndent = indentInfo.getWhitespacesIndent();
        for (String input : inputs) {
            str.append(lineDelimiter);
            str.append(whitespacesIndent);
            str.append(QuteCodeActionForMissingInputs.findIndentation(template, range));
            str.append(String.format("<input name=\"%s\" >", input));
        }
        str.append(lineDelimiter);
        str.append(whitespacesIndent);
        return str.toString();
    }

    private static String findIndentation(Template template, Range range) throws BadLocationException {
        for (int i = 0; i < range.getEnd().getLine(); ++i) {
            String indent = template.lineIndentInfo(i).getWhitespacesIndent();
            if (indent.isEmpty() || indent.charAt(0) == ' ' && indent.length() != 2 && indent.length() != 4 && indent.length() != 6 && indent.length() != 8) continue;
            return indent;
        }
        return DEFAULT_INDENTATION;
    }
}

