/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.CodeActionFactory;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.RangeOffset;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.services.codeactions.AbstractQuteCodeAction;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;

public class QuteCodeActionForMissingParameters
extends AbstractQuteCodeAction {
    private static final Logger LOGGER = Logger.getLogger(QuteCodeActionForMissingParameters.class.getName());

    @Override
    public void doCodeActions(CodeActionRequest request, List<CompletableFuture<Void>> codeActionResolveFutures, List<CodeAction> codeActions) {
        try {
            Section section;
            Node node = request.getCoveredNode();
            if (node == null) {
                return;
            }
            Section section2 = section = node.getKind() == NodeKind.Section ? (Section)node : null;
            if (section == null) {
                return;
            }
            Template template = request.getTemplate();
            List<String> requiredUserTagParamNames = template.getProject().findUserTag(section.getTag()).getRequiredParameterNames();
            int startRangeOffset = section.getStartTagNameCloseOffset();
            for (Parameter param : section.getParameters()) {
                if (requiredUserTagParamNames.contains(param.getName())) {
                    requiredUserTagParamNames.remove(param.getName());
                }
                startRangeOffset = param.getEnd();
            }
            Range range = QutePositionUtility.createRange(new RangeOffset(startRangeOffset, section.getStartTagCloseOffset()), template);
            CodeAction insertAllInputs = CodeActionFactory.replace("Insert required parameters", range, QuteCodeActionForMissingParameters.generateParameters(requiredUserTagParamNames), template.getTextDocument(), request.getDiagnostic());
            codeActions.add(insertAllInputs);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of generate missing parameters code action failed", e);
        }
    }

    private static String generateParameters(List<String> paramNames) throws BadLocationException {
        StringBuilder str = new StringBuilder();
        for (String paramName : paramNames) {
            str.append(" ");
            if (paramName.equals("it")) {
                str.append("\"\"");
                continue;
            }
            str.append(String.format("%s=\"%s\"", paramName, paramName));
        }
        return str.toString();
    }
}

