/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.expression.NamespacePart;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.services.codeactions.AbstractQuteCodeAction;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import com.redhat.qute.services.diagnostics.QuteErrorCode;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;

public class QuteCodeActionForUndefinedNamespace
extends AbstractQuteCodeAction {
    private static final Logger LOGGER = Logger.getLogger(QuteCodeActionForUndefinedNamespace.class.getName());
    private static final String UNDEFINED_NAMESPACE_SEVERITY_SETTING = "qute.validation.undefinedNamespace.severity";

    @Override
    public void doCodeActions(CodeActionRequest request, List<CompletableFuture<Void>> codeActionResolveFutures, List<CodeAction> codeActions) {
        try {
            Node node = request.getCoveredNode();
            if (node == null) {
                return;
            }
            NamespacePart part = (NamespacePart)node;
            Template template = request.getTemplate();
            Diagnostic diagnostic = request.getDiagnostic();
            this.doCodeActionsForSimilarValues(part, template, diagnostic, codeActions);
            boolean canUpdateConfiguration = request.getSharedSettings().getCommandCapabilities().isCommandSupported("qute.command.configuration.update");
            if (canUpdateConfiguration) {
                QuteCodeActionForUndefinedNamespace.doCodeActionToSetIgnoreSeverity(template, diagnostic, QuteErrorCode.UndefinedNamespace, codeActions, UNDEFINED_NAMESPACE_SEVERITY_SETTING);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of undefined namespace code action failed", e);
        }
    }

    private void doCodeActionsForSimilarValues(NamespacePart part, Template template, Diagnostic diagnostic, List<CodeAction> codeActions) throws BadLocationException {
        QuteProject project = template.getProject();
        if (project == null) {
            return;
        }
        HashSet<String> existingProperties = new HashSet<String>();
        for (String namespace : project.getAllNamespaces()) {
            this.doCodeActionsForSimilarValue(part, namespace, template, existingProperties, diagnostic, codeActions);
        }
    }
}

