/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.CodeActionFactory;
import com.redhat.qute.ls.commons.TextDocument;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.SectionMetadata;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.LoopSection;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.datamodel.ExtendedDataModelParameter;
import com.redhat.qute.project.datamodel.ExtendedDataModelTemplate;
import com.redhat.qute.services.codeactions.AbstractQuteCodeAction;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import com.redhat.qute.services.diagnostics.QuteErrorCode;
import com.redhat.qute.utils.StringUtils;
import com.redhat.qute.utils.UserTagUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;

public class QuteCodeActionForUndefinedObject
extends AbstractQuteCodeAction {
    private static final Logger LOGGER = Logger.getLogger(QuteCodeActionForUndefinedObject.class.getName());
    private static final String UNDEFINED_OBJECT_CODEACTION_TITLE = "Declare `{0}` with parameter declaration.";
    private static final String UNDEFINED_OBJECT_SEVERITY_SETTING = "qute.validation.undefinedObject.severity";

    @Override
    public void doCodeActions(CodeActionRequest request, List<CompletableFuture<Void>> codeActionResolveFutures, List<CodeAction> codeActions) {
        try {
            Node node = request.getCoveredNode();
            if (node == null) {
                return;
            }
            ObjectPart part = (ObjectPart)node;
            Template template = request.getTemplate();
            Diagnostic diagnostic = request.getDiagnostic();
            this.doCodeActionsForSimilarValues(part, template, diagnostic, codeActions);
            QuteCodeActionForUndefinedObject.doCodeActionToInsertParameterDeclaration(part, template, diagnostic, codeActions);
            QuteCodeActionForUndefinedObject.doCodeActionToAddOptionalSuffix(template, diagnostic, codeActions);
            boolean canUpdateConfiguration = request.getSharedSettings().getCommandCapabilities().isCommandSupported("qute.command.configuration.update");
            if (canUpdateConfiguration) {
                QuteCodeActionForUndefinedObject.doCodeActionToSetIgnoreSeverity(template, diagnostic, QuteErrorCode.UndefinedObject, codeActions, UNDEFINED_OBJECT_SEVERITY_SETTING);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of undefined object code action failed", e);
        }
    }

    private void doCodeActionsForSimilarValues(ObjectPart part, Template template, Diagnostic diagnostic, List<CodeAction> codeActions) throws BadLocationException {
        List globalResolvers;
        Section section;
        int offset = template.offsetAt(diagnostic.getRange().getStart());
        QuteProject project = template.getProject();
        if (project == null) {
            return;
        }
        HashSet<String> existingProperties = new HashSet<String>();
        Section section2 = section = part != null ? part.getParentSection() : null;
        if (section != null) {
            if (section.getKind() == NodeKind.Section) {
                Object alias2;
                boolean collect = true;
                if (section.getSectionKind() == SectionKind.FOR || section.getSectionKind() == SectionKind.EACH) {
                    LoopSection iterableSection = (LoopSection)section;
                    if (iterableSection.isInElseBlock(offset)) {
                        collect = false;
                    } else {
                        alias2 = iterableSection.getAlias();
                        if (!StringUtils.isEmpty((String)alias2)) {
                            this.doCodeActionsForSimilarValue(part, (String)alias2, template, existingProperties, diagnostic, codeActions);
                        }
                    }
                }
                if (collect) {
                    List<SectionMetadata> metadatas = section.getMetadata();
                    alias2 = metadatas.iterator();
                    while (alias2.hasNext()) {
                        SectionMetadata metadata = (SectionMetadata)alias2.next();
                        this.doCodeActionsForSimilarValue(part, metadata.getName(), template, existingProperties, diagnostic, codeActions);
                    }
                }
            }
            switch (section.getSectionKind()) {
                case LET: 
                case SET: {
                    String parameterName;
                    List<Parameter> parameters = section.getParameters();
                    if (parameters == null) break;
                    for (Parameter parameter : parameters) {
                        parameterName = parameter.getName();
                        this.doCodeActionsForSimilarValue(part, parameterName, template, existingProperties, diagnostic, codeActions);
                    }
                    break;
                }
                case IF: {
                    String parameterName;
                    List<Parameter> parameters = section.getParameters();
                    if (parameters == null) break;
                    for (Parameter parameter : parameters) {
                        if (!parameter.isOptional()) continue;
                        parameterName = parameter.getName();
                        this.doCodeActionsForSimilarValue(part, parameterName, template, existingProperties, diagnostic, codeActions);
                    }
                    break;
                }
            }
        }
        if ((globalResolvers = (List)project.getGlobalVariables().getNow(null)) != null) {
            for (Object resolver : globalResolvers) {
                this.doCodeActionsForSimilarValue(part, resolver.getName(), template, existingProperties, diagnostic, codeActions);
            }
        }
        List aliases = template.getChildren().stream().filter(n -> n.getKind() == NodeKind.ParameterDeclaration).map(n -> ((ParameterDeclaration)n).getAlias()).filter(alias -> alias != null).collect(Collectors.toList());
        for (Object alias3 : aliases) {
            this.doCodeActionsForSimilarValue(part, (String)alias3, template, existingProperties, diagnostic, codeActions);
        }
        ExtendedDataModelTemplate dataModel = project.getDataModelTemplate(template).getNow(null);
        if (dataModel != null) {
            for (ExtendedDataModelParameter parameter : dataModel.getParameters()) {
                this.doCodeActionsForSimilarValue(part, parameter.getKey(), template, existingProperties, diagnostic, codeActions);
            }
        }
        if (UserTagUtils.isUserTag(template)) {
            Collection<SectionMetadata> specialKeysMetadatas = UserTagUtils.getSpecialKeys();
            for (SectionMetadata metadata : specialKeysMetadatas) {
                String name = metadata.getName();
                this.doCodeActionsForSimilarValue(part, name, template, existingProperties, diagnostic, codeActions);
            }
        }
    }

    private static void doCodeActionToInsertParameterDeclaration(ObjectPart part, Template template, Diagnostic diagnostic, List<CodeAction> codeActions) throws BadLocationException {
        String partName = part.getPartName();
        TextDocument document = template.getTextDocument();
        String lineDelimiter = document.lineDelimiter(0);
        String title = MessageFormat.format(UNDEFINED_OBJECT_CODEACTION_TITLE, partName);
        Position position = new Position(0, 0);
        Section ownerSection = part.getParent().getParent().getOwnerSection();
        boolean isIterable = ownerSection != null && ownerSection.isIterable();
        StringBuilder insertText = new StringBuilder("{@");
        if (isIterable) {
            insertText.append("java.util.List");
        } else {
            insertText.append("java.lang.String");
        }
        insertText.append(" ");
        insertText.append(partName);
        insertText.append("}");
        insertText.append(lineDelimiter);
        CodeAction insertParameterDeclarationQuickFix = CodeActionFactory.insert(title, position, insertText.toString(), document, diagnostic);
        codeActions.add(insertParameterDeclarationQuickFix);
    }

    private static void doCodeActionToAddOptionalSuffix(Template template, Diagnostic diagnostic, List<CodeAction> codeActions) throws BadLocationException {
        Position objectEnd = diagnostic.getRange().getEnd();
        int diagnosticStartOffset = template.offsetAt(diagnostic.getRange().getStart());
        int diagnosticEndOffset = template.offsetAt(objectEnd);
        String title = MessageFormat.format("Append ?? to undefined object `{0}`", template.getText(diagnosticStartOffset, diagnosticEndOffset));
        CodeAction appendOptionalSuffix = CodeActionFactory.insert(title, objectEnd, "??", template.getTextDocument(), diagnostic);
        codeActions.add(appendOptionalSuffix);
    }
}

