/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.CodeActionFactory;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.services.codeactions.AbstractQuteCodeAction;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;

public class QuteCodeActionForUndefinedSectionTag
extends AbstractQuteCodeAction {
    private static final String UNDEFINED_SECTION_TAG_CODEACTION_TITLE = "Create the user tag file `{0}`.";
    private static final Logger LOGGER = Logger.getLogger(QuteCodeActionForUndefinedSectionTag.class.getName());

    @Override
    public void doCodeActions(CodeActionRequest request, List<CompletableFuture<Void>> codeActionResolveFutures, List<CodeAction> codeActions) {
        try {
            Template template = request.getTemplate();
            Diagnostic diagnostic = request.getDiagnostic();
            QuteProject project = template.getProject();
            if (project == null) {
                return;
            }
            String tagName = null;
            Node node = request.getCoveredNode();
            if (node.getKind() == NodeKind.Section) {
                Section section = (Section)node;
                tagName = section.getTag();
            }
            if (tagName == null) {
                return;
            }
            String preferedFileExtension = ".html";
            String tagFileUri = project.getTagsDir().resolve(tagName + preferedFileExtension).toUri().toString();
            String title = MessageFormat.format(UNDEFINED_SECTION_TAG_CODEACTION_TITLE, tagName);
            CodeAction createUserTagFile = CodeActionFactory.createFile(title, tagFileUri, "", diagnostic);
            codeActions.add(createUserTagFile);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of undefined user tag code action failed", e);
        }
    }
}

