/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.datamodel.resolvers.MethodValueResolver;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.codeactions.AbstractQuteCodeAction;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import com.redhat.qute.services.nativemode.JavaTypeAccessibiltyRule;
import com.redhat.qute.services.nativemode.JavaTypeFilter;
import com.redhat.qute.settings.QuteNativeSettings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;

public class QuteCodeActionForUnknownMethod
extends AbstractQuteCodeAction {
    private static final Logger LOGGER = Logger.getLogger(QuteCodeActionForUnknownMethod.class.getName());
    private final QuteProjectRegistry projectRegistry;

    public QuteCodeActionForUnknownMethod(QuteProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    @Override
    public void doCodeActions(CodeActionRequest request, List<CompletableFuture<Void>> codeActionResolveFutures, List<CodeAction> codeActions) {
        try {
            Node node = request.getCoveredNode();
            if (node == null) {
                return;
            }
            ResolvedJavaTypeInfo baseResolvedType = request.getJavaTypeOfCoveredNode();
            if (baseResolvedType == null) {
                return;
            }
            MethodPart part = (MethodPart)node;
            Template template = request.getTemplate();
            Diagnostic diagnostic = request.getDiagnostic();
            QuteNativeSettings nativeImageSettings = request.getSharedSettings().getNativeSettings();
            this.doCodeActionsForSimilarValues(part, template, diagnostic, baseResolvedType, nativeImageSettings, codeActions);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of unknown method code action failed", e);
        }
    }

    private void doCodeActionsForSimilarValues(MethodPart part, Template template, Diagnostic diagnostic, ResolvedJavaTypeInfo baseResolvedType, QuteNativeSettings nativeImageSettings, List<CodeAction> codeActions) {
        QuteProject project = template.getProject();
        if (project == null) {
            return;
        }
        JavaTypeFilter filter = this.projectRegistry.getJavaTypeFilter(project.getUri(), nativeImageSettings);
        HashSet<String> existingProperties = new HashSet<String>();
        this.collectSimilarCodeActionsForJavaMethods(part, template, project, baseResolvedType, filter, existingProperties, diagnostic, codeActions);
        List<MethodValueResolver> resolvers = project.getResolversFor(baseResolvedType);
        for (MethodValueResolver method : resolvers) {
            if (!method.isValidName()) continue;
            this.doCodeActionsForSimilarValue(part, method.getMethodName(), template, existingProperties, diagnostic, codeActions);
        }
    }

    private void collectSimilarCodeActionsForJavaMethods(MethodPart part, Template template, QuteProject project, ResolvedJavaTypeInfo baseResolvedType, JavaTypeFilter filter, Set<String> existingProperties, Diagnostic diagnostic, List<CodeAction> codeActions) {
        this.collectSimilarCodeActionsForJavaMethods(part, template, project, baseResolvedType, filter, existingProperties, diagnostic, codeActions, new HashSet<ResolvedJavaTypeInfo>());
    }

    private void collectSimilarCodeActionsForJavaMethods(MethodPart part, Template template, QuteProject project, ResolvedJavaTypeInfo baseResolvedType, JavaTypeFilter filter, Set<String> existingProperties, Diagnostic diagnostic, List<CodeAction> codeActions, Set<ResolvedJavaTypeInfo> visited) {
        List<String> extendedTypes;
        if (visited.contains(baseResolvedType)) {
            return;
        }
        visited.add(baseResolvedType);
        for (JavaMethodInfo method : baseResolvedType.getMethods()) {
            this.doCodeActionsForSimilarValue(part, method.getName(), template, existingProperties, diagnostic, codeActions);
        }
        JavaTypeAccessibiltyRule javaTypeAccessibility = filter.getJavaTypeAccessibility(baseResolvedType, template.getJavaTypesSupportedInNativeMode());
        if (!QuteCodeActionForUnknownMethod.isIgnoreSuperclasses(baseResolvedType, javaTypeAccessibility, filter) && (extendedTypes = baseResolvedType.getExtendedTypes()) != null) {
            for (String extendedType : extendedTypes) {
                ResolvedJavaTypeInfo resolvedExtendedType = project.resolveJavaTypeSync(extendedType);
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedExtendedType)) continue;
                this.collectSimilarCodeActionsForJavaMethods(part, template, project, resolvedExtendedType, filter, existingProperties, diagnostic, codeActions, visited);
            }
        }
    }
}

