/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.commons.GenerateMissingJavaMemberParams;
import com.redhat.qute.commons.JavaFieldInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.ls.api.QuteTemplateJavaTextEditProvider;
import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.CodeActionFactory;
import com.redhat.qute.parser.expression.PropertyPart;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.datamodel.resolvers.MethodValueResolver;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.codeactions.AbstractQuteCodeAction;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import com.redhat.qute.services.codeactions.CodeActionResolverKind;
import com.redhat.qute.services.codeactions.CodeActionUnresolvedData;
import com.redhat.qute.services.nativemode.JavaTypeAccessibiltyRule;
import com.redhat.qute.services.nativemode.JavaTypeFilter;
import com.redhat.qute.settings.QuteNativeSettings;
import com.redhat.qute.settings.SharedSettings;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;

public class QuteCodeActionForUnknownProperty
extends AbstractQuteCodeAction {
    private static final Logger LOGGER = Logger.getLogger(QuteCodeActionForUnknownProperty.class.getName());
    private static final String APPEND_TO_TEMPLATE_EXTENSIONS = "Create template extension `{0}()` in class `{1}`.";
    private static final String CREATE_TEMPLATE_EXTENSIONS = "Create template extension `{0}()` in a new template extensions class.";
    private static final String CREATE_GETTER = "Create getter `get{0}()` in `{1}`.";
    private static final String CREATE_PUBLIC_FIELD = "Create public field `{0}` in `{1}`.";
    private final QuteProjectRegistry projectRegistry;

    public QuteCodeActionForUnknownProperty(QuteProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    @Override
    public void doCodeActions(CodeActionRequest request, List<CompletableFuture<Void>> codeActionResolveFutures, List<CodeAction> codeActions) {
        try {
            Node node = request.getCoveredNode();
            if (node == null) {
                return;
            }
            Template template = request.getTemplate();
            QuteProject project = template.getProject();
            if (project == null) {
                return;
            }
            ResolvedJavaTypeInfo baseResolvedType = request.getJavaTypeOfCoveredNode();
            if (baseResolvedType == null) {
                return;
            }
            Diagnostic diagnostic = request.getDiagnostic();
            QuteTemplateJavaTextEditProvider javaTextEditProvider = request.getTextEditProvider();
            SharedSettings sharedSettings = request.getSharedSettings();
            Set<String> namespaces = project.getAllTemplateExtensionsClasses();
            PropertyPart propertyPart = (PropertyPart)request.getCoveredNode();
            QuteNativeSettings nativeImageSettings = request.getSharedSettings().getNativeSettings();
            this.doCodeActionsForSimilarValues(propertyPart, template, diagnostic, baseResolvedType, nativeImageSettings, codeActions);
            String missingProperty = propertyPart.getPartName();
            String resolvedType = baseResolvedType.getSignature();
            String projectUri = template.getProjectUri();
            String propertyCapitalized = missingProperty.substring(0, 1).toUpperCase() + missingProperty.substring(1);
            String fileUri = template.getUri();
            if (!baseResolvedType.isBinary()) {
                QuteCodeActionForUnknownProperty.doCodeActionToCreateField(missingProperty, resolvedType, projectUri, fileUri, propertyCapitalized, diagnostic, javaTextEditProvider, sharedSettings, codeActionResolveFutures, codeActions);
                QuteCodeActionForUnknownProperty.doCodeActionToCreateGetter(missingProperty, resolvedType, projectUri, fileUri, propertyCapitalized, diagnostic, javaTextEditProvider, sharedSettings, codeActionResolveFutures, codeActions);
            }
            QuteCodeActionForUnknownProperty.doCodeActionToAddTemplateExtension(missingProperty, resolvedType, projectUri, fileUri, diagnostic, javaTextEditProvider, namespaces, sharedSettings, codeActionResolveFutures, codeActions);
            QuteCodeActionForUnknownProperty.doCodeActionToCreateTemplateExtensionsClass(missingProperty, resolvedType, projectUri, fileUri, propertyCapitalized, diagnostic, javaTextEditProvider, sharedSettings, codeActionResolveFutures, codeActions);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of unknown property code action failed", e);
        }
    }

    private void doCodeActionsForSimilarValues(PropertyPart part, Template template, Diagnostic diagnostic, ResolvedJavaTypeInfo baseResolvedType, QuteNativeSettings nativeImageSettings, List<CodeAction> codeActions) {
        QuteProject project = template.getProject();
        if (project == null) {
            return;
        }
        JavaTypeFilter filter = this.projectRegistry.getJavaTypeFilter(project.getUri(), nativeImageSettings);
        HashSet<String> existingProperties = new HashSet<String>();
        this.collectSimilarCodeActionsForJavaProperties(part, template, project, baseResolvedType, filter, existingProperties, diagnostic, codeActions);
        List<MethodValueResolver> resolvers = project.getResolversFor(baseResolvedType);
        for (MethodValueResolver method : resolvers) {
            if (!method.isValidName() || method.hasParameters()) continue;
            String methodName = method.getMethodName();
            this.doCodeActionsForSimilarValue(part, methodName, template, existingProperties, diagnostic, codeActions);
            String getterName = method.getGetterName();
            if (getterName == null) continue;
            this.doCodeActionsForSimilarValue(part, getterName, template, existingProperties, diagnostic, codeActions);
        }
    }

    private void collectSimilarCodeActionsForJavaProperties(PropertyPart part, Template template, QuteProject project, ResolvedJavaTypeInfo baseResolvedType, JavaTypeFilter filter, Set<String> existingProperties, Diagnostic diagnostic, List<CodeAction> codeActions) {
        this.collectSimilarCodeActionsForJavaProperties(part, template, project, baseResolvedType, filter, existingProperties, diagnostic, codeActions, new HashSet<ResolvedJavaTypeInfo>());
    }

    private void collectSimilarCodeActionsForJavaProperties(PropertyPart part, Template template, QuteProject project, ResolvedJavaTypeInfo baseResolvedType, JavaTypeFilter filter, Set<String> existingProperties, Diagnostic diagnostic, List<CodeAction> codeActions, Set<ResolvedJavaTypeInfo> visited) {
        List<String> extendedTypes;
        if (visited.contains(baseResolvedType)) {
            return;
        }
        visited.add(baseResolvedType);
        for (JavaFieldInfo field : baseResolvedType.getFields()) {
            this.doCodeActionsForSimilarValue(part, field.getName(), template, existingProperties, diagnostic, codeActions);
        }
        for (JavaMethodInfo method : baseResolvedType.getMethods()) {
            String getterName = method.getGetterName();
            if (getterName == null) continue;
            this.doCodeActionsForSimilarValue(part, getterName, template, existingProperties, diagnostic, codeActions);
        }
        JavaTypeAccessibiltyRule rule = filter.getJavaTypeAccessibility(baseResolvedType, template.getJavaTypesSupportedInNativeMode());
        if (!QuteCodeActionForUnknownProperty.isIgnoreSuperclasses(baseResolvedType, rule, filter) && (extendedTypes = baseResolvedType.getExtendedTypes()) != null) {
            for (String extendedType : extendedTypes) {
                ResolvedJavaTypeInfo resolvedExtendedType = project.resolveJavaTypeSync(extendedType);
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedExtendedType)) continue;
                this.collectSimilarCodeActionsForJavaProperties(part, template, project, resolvedExtendedType, filter, existingProperties, diagnostic, codeActions, visited);
            }
        }
    }

    private static void doCodeActionToCreateField(String missingProperty, String resolvedType, String projectUri, String fileUri, String propertyCapitalized, Diagnostic diagnostic, QuteTemplateJavaTextEditProvider javaTextEditProvider, SharedSettings settings, List<CompletableFuture<Void>> registrations, List<CodeAction> codeActions) {
        GenerateMissingJavaMemberParams publicFieldParams = new GenerateMissingJavaMemberParams(GenerateMissingJavaMemberParams.MemberType.Field, missingProperty, resolvedType, projectUri);
        CodeAction createPublicField = CodeActionFactory.createCodeActionWithData(MessageFormat.format(CREATE_PUBLIC_FIELD, missingProperty, resolvedType), publicFieldParams, Collections.singletonList(diagnostic));
        codeActions.add(createPublicField);
        if (settings.getCodeActionSettings().isResolveSupported()) {
            createPublicField.setData((Object)new CodeActionUnresolvedData(fileUri, CodeActionResolverKind.GenerateMissingMember, publicFieldParams));
        } else {
            registrations.add((CompletableFuture<Void>)javaTextEditProvider.generateMissingJavaMember(publicFieldParams).thenAccept(workspaceEdit -> {
                if (workspaceEdit == null) {
                    return;
                }
                createPublicField.setEdit(workspaceEdit);
            }));
        }
    }

    private static void doCodeActionToCreateGetter(String missingProperty, String resolvedType, String projectUri, String fileUri, String propertyCapitalized, Diagnostic diagnostic, QuteTemplateJavaTextEditProvider javaTextEditProvider, SharedSettings settings, List<CompletableFuture<Void>> registrations, List<CodeAction> codeActions) {
        GenerateMissingJavaMemberParams getterParams = new GenerateMissingJavaMemberParams(GenerateMissingJavaMemberParams.MemberType.Getter, missingProperty, resolvedType, projectUri);
        CodeAction createGetter = CodeActionFactory.createCodeActionWithData(MessageFormat.format(CREATE_GETTER, propertyCapitalized, resolvedType), getterParams, Collections.singletonList(diagnostic));
        codeActions.add(createGetter);
        if (settings.getCodeActionSettings().isResolveSupported()) {
            createGetter.setData((Object)new CodeActionUnresolvedData(fileUri, CodeActionResolverKind.GenerateMissingMember, getterParams));
        } else {
            registrations.add((CompletableFuture<Void>)javaTextEditProvider.generateMissingJavaMember(getterParams).thenAccept(workspaceEdit -> {
                if (workspaceEdit == null) {
                    return;
                }
                createGetter.setEdit(workspaceEdit);
            }));
        }
    }

    private static void doCodeActionToAddTemplateExtension(String missingProperty, String resolvedType, String projectUri, String fileUri, Diagnostic diagnostic, QuteTemplateJavaTextEditProvider javaTextEditProvider, Set<String> templateExtensionsClasses, SharedSettings settings, List<CompletableFuture<Void>> registrations, List<CodeAction> codeActions) {
        for (String templateExtensionsClass : templateExtensionsClasses) {
            GenerateMissingJavaMemberParams appendToTemplateExtensionsParams = new GenerateMissingJavaMemberParams(GenerateMissingJavaMemberParams.MemberType.AppendTemplateExtension, missingProperty, resolvedType, projectUri, templateExtensionsClass);
            CodeAction appendToTemplateExtensions = CodeActionFactory.createCodeActionWithData(MessageFormat.format(APPEND_TO_TEMPLATE_EXTENSIONS, missingProperty, templateExtensionsClass), appendToTemplateExtensionsParams, Collections.singletonList(diagnostic));
            codeActions.add(appendToTemplateExtensions);
            if (settings.getCodeActionSettings().isResolveSupported()) {
                appendToTemplateExtensions.setData((Object)new CodeActionUnresolvedData(fileUri, CodeActionResolverKind.GenerateMissingMember, appendToTemplateExtensionsParams));
                continue;
            }
            registrations.add((CompletableFuture<Void>)javaTextEditProvider.generateMissingJavaMember(appendToTemplateExtensionsParams).thenAccept(workspaceEdit -> {
                if (workspaceEdit == null) {
                    return;
                }
                appendToTemplateExtensions.setEdit(workspaceEdit);
            }));
        }
    }

    private static void doCodeActionToCreateTemplateExtensionsClass(String missingProperty, String resolvedType, String projectUri, String fileUri, String propertyCapitalized, Diagnostic diagnostic, QuteTemplateJavaTextEditProvider javaTextEditProvider, SharedSettings settings, List<CompletableFuture<Void>> registrations, List<CodeAction> codeActions) {
        GenerateMissingJavaMemberParams createTemplateExtensionsParams = new GenerateMissingJavaMemberParams(GenerateMissingJavaMemberParams.MemberType.CreateTemplateExtension, missingProperty, resolvedType, projectUri);
        CodeAction createTemplateExtensions = CodeActionFactory.createCodeActionWithData(MessageFormat.format(CREATE_TEMPLATE_EXTENSIONS, missingProperty), createTemplateExtensionsParams, Collections.singletonList(diagnostic));
        codeActions.add(createTemplateExtensions);
        if (settings.getCodeActionSettings().isResolveSupported()) {
            createTemplateExtensions.setData((Object)new CodeActionUnresolvedData(fileUri, CodeActionResolverKind.GenerateMissingMember, createTemplateExtensionsParams));
        } else {
            registrations.add((CompletableFuture<Void>)javaTextEditProvider.generateMissingJavaMember(createTemplateExtensionsParams).thenAccept(workspaceEdit -> {
                if (workspaceEdit == null) {
                    return;
                }
                createTemplateExtensions.setEdit(workspaceEdit);
            }));
        }
    }
}

