/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.codeactions;

import com.redhat.qute.ls.api.QuteTemplateJavaTextEditProvider;
import com.redhat.qute.services.codeactions.CodeActionResolver;
import com.redhat.qute.services.codeactions.CodeActionResolverKind;
import com.redhat.qute.services.codeactions.CodeActionUnresolvedData;
import com.redhat.qute.services.codeactions.QuteCodeActionResolverForGenerateMissingMember;
import com.redhat.qute.utils.JSONUtility;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;

public class QuteTemplateCodeActionResolvers {
    private static final Logger LOGGER = Logger.getLogger(QuteTemplateCodeActionResolvers.class.getName());
    private Map<CodeActionResolverKind, CodeActionResolver> resolvers;

    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction unresolved, QuteTemplateJavaTextEditProvider javaTextEditProvider) {
        CodeActionUnresolvedData unresolvedData;
        CodeActionResolverKind resolverKind;
        CodeActionResolver resolver;
        if (this.resolvers == null) {
            this.initalizeResolvers(javaTextEditProvider);
        }
        if ((resolver = this.resolvers.get((Object)(resolverKind = (unresolvedData = JSONUtility.toModel(unresolved.getData(), CodeActionUnresolvedData.class)).getResolverKind()))) != null) {
            return resolver.resolveCodeAction(unresolved);
        }
        LOGGER.severe(String.format("Cannot resolve CodeAction of kind %s", new Object[]{resolverKind}));
        return null;
    }

    private synchronized void initalizeResolvers(QuteTemplateJavaTextEditProvider javaTextEditProvider) {
        if (this.resolvers == null) {
            this.resolvers = new HashMap<CodeActionResolverKind, CodeActionResolver>();
            this.resolvers.put(CodeActionResolverKind.GenerateMissingMember, new QuteCodeActionResolverForGenerateMissingMember(javaTextEditProvider));
        }
    }
}

