/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.commands;

import com.redhat.qute.ls.api.QuteTemplateProvider;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.services.commands.ArgumentsUtils;
import com.redhat.qute.services.commands.IDelegateCommandHandler;
import com.redhat.qute.settings.SharedSettings;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public abstract class AbstractTemplateCommandHandler
implements IDelegateCommandHandler {
    private final QuteTemplateProvider templateProvider;

    public AbstractTemplateCommandHandler(QuteTemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
    }

    @Override
    public final CompletableFuture<Object> executeCommand(ExecuteCommandParams params, SharedSettings sharedSettings, CancelChecker cancelChecker) throws Exception {
        TextDocumentIdentifier identifier = ArgumentsUtils.getArgAt(params, 0, TextDocumentIdentifier.class);
        String uri = identifier.getUri();
        Template template = this.templateProvider.getTemplate(uri);
        if (template == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' cannot find the Qute template with the URI '%s'.", params.getCommand(), uri));
        }
        return this.executeCommand(template, params, sharedSettings, cancelChecker);
    }

    protected abstract CompletableFuture<Object> executeCommand(Template var1, ExecuteCommandParams var2, SharedSettings var3, CancelChecker var4) throws Exception;
}

