/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.commands;

import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.GenerateTemplateInfo;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.services.commands.ArgumentsUtils;
import com.redhat.qute.services.commands.IDelegateCommandHandler;
import com.redhat.qute.services.commands.ResolvedDataModelParameter;
import com.redhat.qute.settings.SharedSettings;
import com.redhat.qute.utils.IOUtils;
import io.quarkus.qute.Engine;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Template;
import io.quarkus.qute.ValueResolver;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteGenerateTemplateContentCommandHandler
implements IDelegateCommandHandler {
    public static final String COMMAND_ID = "qute.command.generate.template.content";
    private final QuteProjectRegistry projectRegistry;
    private Engine engine;

    public QuteGenerateTemplateContentCommandHandler(QuteProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
        this.engine = this.createQuteEngine();
    }

    @Override
    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params, SharedSettings sharedSettings, CancelChecker cancelChecker) throws Exception {
        GenerateTemplateInfo info = ArgumentsUtils.getArgAt(params, 0, GenerateTemplateInfo.class);
        String projectUri = info.getProjectUri();
        QuteProject project = this.projectRegistry.getProject(projectUri);
        if (project == null) {
            throw new Exception("Cannot findproject with the uri '" + projectUri + "'.");
        }
        List<DataModelParameter> parameters = info.getParameters();
        ArrayList<ResolvedDataModelParameter> resolvedParameters = new ArrayList<ResolvedDataModelParameter>(parameters.size());
        ArrayList<CompletableFuture<ResolvedJavaTypeInfo>> resolvingJavaTypeFutures = new ArrayList<CompletableFuture<ResolvedJavaTypeInfo>>();
        for (DataModelParameter parameter : parameters) {
            CompletableFuture<ResolvedJavaTypeInfo> future = project.resolveJavaType(parameter.getSourceType());
            resolvedParameters.add(new ResolvedDataModelParameter(parameter, future));
            resolvingJavaTypeFutures.add(future);
        }
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(resolvingJavaTypeFutures.toArray(new CompletableFuture[resolvingJavaTypeFutures.size()]));
        return allFutures.thenApply(Void2 -> {
            InputStream in = QuteGenerateTemplateContentCommandHandler.class.getResourceAsStream("generate.qute.html");
            String templateContent = IOUtils.convertStreamToString(in);
            Template template = this.getEngine().parse(templateContent);
            String result = template.data("classes", (Object)resolvedParameters).render();
            return result;
        });
    }

    private Engine getEngine() {
        if (this.engine == null) {
            this.engine = this.createQuteEngine();
        }
        return this.engine;
    }

    private synchronized Engine createQuteEngine() {
        if (this.engine != null) {
            return this.engine;
        }
        return Engine.builder().addDefaults().addValueResolver((ValueResolver)new ReflectionValueResolver()).build();
    }
}

