/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.commands.validation;

import com.redhat.qute.services.commands.ArgumentsUtils;
import com.redhat.qute.services.commands.IDelegateCommandHandler;
import com.redhat.qute.services.commands.validation.TemplateValidationStatus;
import com.redhat.qute.settings.QuteValidationSettings;
import com.redhat.qute.settings.SharedSettings;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteTemplateValidationStatusCommandHandler
implements IDelegateCommandHandler {
    public static final String COMMAND_ID = "qute.command.validation.template.status";

    @Override
    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params, SharedSettings sharedSettings, CancelChecker cancelChecker) throws Exception {
        String fileUri = ArgumentsUtils.getArgAt(params, 0, String.class);
        TemplateValidationStatus status = new TemplateValidationStatus();
        QuteValidationSettings validationSettings = sharedSettings.getValidationSettings(fileUri);
        if (validationSettings == null) {
            status.setValidationEnabled(true);
            status.setExcluded(Collections.emptyList());
        } else {
            status.setValidationEnabled(validationSettings.isEnabled());
            status.setExcluded(validationSettings.getMatchingExcluded(fileUri));
        }
        return CompletableFuture.completedFuture(status);
    }
}

