/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.completions;

import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.services.completions.CompletionRequest;
import com.redhat.qute.settings.QuteCompletionSettings;
import com.redhat.qute.settings.QuteFormattingSettings;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class QuteCompletionForTemplateIds {
    private static final Comparator<QuteTextDocument> TEMPLATE_ID_COMPARATOR = (d1, d2) -> {
        String[] paths2;
        String templateId1 = d1.getTemplateId();
        String templateId2 = d2.getTemplateId();
        String[] paths1 = templateId1.split("/");
        if (paths1.length < (paths2 = templateId2.split("/")).length) {
            return -1;
        }
        if (paths1.length > paths2.length) {
            return 1;
        }
        for (int i = 0; i < paths1.length; ++i) {
            String path1 = paths1[i];
            String path2 = paths2[i];
            if (path1.equals(path2)) continue;
            return path1.compareTo(path2);
        }
        return 0;
    };

    public CompletableFuture<CompletionList> doCompleteTemplateId(CompletionRequest completionRequest, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, CancelChecker cancelChecker) {
        CompletionList list = new CompletionList();
        list.setItems(new ArrayList());
        Template template = completionRequest.getTemplate();
        QuteProject project = template.getProject();
        if (project != null) {
            String currentTemplateId = template.getTemplateId();
            Range range = this.getReplaceRange(completionRequest.getNode(), completionRequest.getOffset(), template);
            ArrayList<QuteTextDocument> documents = new ArrayList<QuteTextDocument>(project.getDocuments());
            for (QuteProject projectDependency : project.getProjectDependencies()) {
                documents.addAll(projectDependency.getDocuments());
            }
            Collections.sort(documents, TEMPLATE_ID_COMPARATOR);
            StringBuilder sortText = new StringBuilder();
            Map<String, List<QuteTextDocument>> templateIds = this.createTemplateIds(documents, currentTemplateId);
            for (Map.Entry<String, List<QuteTextDocument>> ids : templateIds.entrySet()) {
                String sort = sortText.append("a").toString();
                List<QuteTextDocument> documentsForId = ids.getValue();
                if (documentsForId.size() == 1) {
                    this.addTemplateId(ids.getKey(), documentsForId.get(0), range, sort, list);
                    continue;
                }
                for (QuteTextDocument document : documentsForId) {
                    this.addTemplateId(document.getTemplateId(), document, range, sort, list);
                }
            }
        }
        return CompletableFuture.completedFuture(list);
    }

    private Map<String, List<QuteTextDocument>> createTemplateIds(List<QuteTextDocument> documents, String currentTemplateId) {
        LinkedHashMap<String, List<QuteTextDocument>> templateIds = new LinkedHashMap<String, List<QuteTextDocument>>();
        for (QuteTextDocument document : documents) {
            String templateId;
            if (document.isUserTag() || (templateId = document.getTemplateId()).equals(currentTemplateId)) continue;
            int index = templateId.lastIndexOf(46);
            String shortSyntax = index != -1 ? templateId.substring(0, index) : templateId;
            ArrayList<QuteTextDocument> documentsForId = (ArrayList<QuteTextDocument>)templateIds.get(shortSyntax);
            if (documentsForId == null) {
                documentsForId = new ArrayList<QuteTextDocument>();
                templateIds.put(shortSyntax, documentsForId);
            }
            documentsForId.add(document);
        }
        return templateIds;
    }

    private Range getReplaceRange(Node node, int offset, Template template) {
        if (node == null) {
            return QutePositionUtility.createRange(offset, offset, template);
        }
        return QutePositionUtility.createRange(node);
    }

    private void addTemplateId(String templateId, QuteTextDocument template, Range range, String sortText, CompletionList list) {
        CompletionItem item = new CompletionItem();
        item.setLabel(templateId);
        item.setFilterText(templateId);
        item.setSortText(sortText);
        item.setKind(CompletionItemKind.Field);
        TextEdit textEdit = new TextEdit(range, templateId);
        item.setTextEdit(Either.forLeft((Object)textEdit));
        list.getItems().add(item);
    }
}

