/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.completions;

import com.redhat.qute.commons.JavaFieldInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.jaxrs.JaxRsParamKind;
import com.redhat.qute.commons.jaxrs.RestParam;
import com.redhat.qute.ls.commons.snippets.SnippetsBuilder;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.CaseOperator;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.SectionMetadata;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.CaseSection;
import com.redhat.qute.parser.template.sections.LoopSection;
import com.redhat.qute.parser.template.sections.WhenSection;
import com.redhat.qute.parser.template.sections.WithSection;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.datamodel.ExtendedDataModelParameter;
import com.redhat.qute.project.datamodel.ExtendedDataModelTemplate;
import com.redhat.qute.project.datamodel.resolvers.FieldValueResolver;
import com.redhat.qute.project.datamodel.resolvers.MethodValueResolver;
import com.redhat.qute.project.datamodel.resolvers.ValueResolver;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.project.tags.UserTagParameter;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.QuteCompletions;
import com.redhat.qute.services.completions.CompletionRequest;
import com.redhat.qute.services.completions.tags.QuteCompletionForTagSection;
import com.redhat.qute.services.nativemode.JavaTypeAccessibiltyRule;
import com.redhat.qute.services.nativemode.JavaTypeFilter;
import com.redhat.qute.settings.QuteCompletionSettings;
import com.redhat.qute.settings.QuteFormattingSettings;
import com.redhat.qute.settings.QuteNativeSettings;
import com.redhat.qute.utils.DocumentationUtils;
import com.redhat.qute.utils.QutePositionUtility;
import com.redhat.qute.utils.StringUtils;
import com.redhat.qute.utils.UserTagUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class QuteCompletionsForExpression {
    private final QuteProjectRegistry projectRegistry;
    private final QuteCompletionForTagSection completionForTagSection;

    public QuteCompletionsForExpression(QuteCompletionForTagSection completionForTagSection, QuteProjectRegistry projectRegistry) {
        this.completionForTagSection = completionForTagSection;
        this.projectRegistry = projectRegistry;
    }

    public CompletableFuture<CompletionList> doCompleteExpression(CompletionRequest completionRequest, Expression expression, Node nodeExpression, Template template, int offset, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, QuteNativeSettings nativeImagesSettings, CancelChecker cancelChecker) {
        if (nodeExpression == null) {
            return this.doCompleteExpressionForObjectPart(completionRequest, expression, null, null, offset, template, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
        }
        if (expression == null) {
            return this.doCompleteExpressionForObjectPart(completionRequest, null, null, nodeExpression, offset, template, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
        }
        if (nodeExpression.getKind() == NodeKind.ExpressionPart) {
            Part part = (Part)nodeExpression;
            switch (part.getPartKind()) {
                case Object: {
                    return this.doCompleteExpressionForObjectPart(null, expression, part.getNamespace(), part, offset, template, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                }
                case Property: {
                    Parts parts = part.getParent();
                    return this.doCompleteExpressionForMemberPart(part, parts, template, false, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                }
                case Method: {
                    MethodPart methodPart = (MethodPart)part;
                    if (methodPart.isInParameters(offset)) {
                        return this.doCompleteExpressionForObjectPart(null, expression, null, null, offset, template, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                    }
                    Parts parts = part.getParent();
                    return this.doCompleteExpressionForMemberPart(part, parts, template, methodPart.isInfixNotation(), completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                }
            }
            return QuteCompletions.EMPTY_FUTURE_COMPLETION;
        }
        if (nodeExpression.getKind() == NodeKind.ExpressionParts) {
            char previous = template.getText().charAt(offset - 1);
            switch (previous) {
                case ':': {
                    Parts parts = (Parts)nodeExpression;
                    Part part = parts.getPartAt(offset + 1);
                    return this.doCompleteExpressionForObjectPart(null, expression, parts.getNamespace(), part, offset, template, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                }
                case '.': {
                    Parts parts = (Parts)nodeExpression;
                    Part part = parts.getPartAt(offset + 1);
                    return this.doCompleteExpressionForMemberPart(part, parts, template, false, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                }
                case ' ': {
                    Parts parts = (Parts)nodeExpression;
                    Part part = parts.getPartAt(offset + 1);
                    Part previousPart = parts.getPreviousPart(part);
                    if (previousPart != null && previousPart.getPartKind() == Parts.PartKind.Method && ((MethodPart)previousPart).isOperator()) {
                        return this.doCompleteExpressionForObjectPart(null, expression, parts.getNamespace(), part, offset, template, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                    }
                    return this.doCompleteExpressionForMemberPart(part, parts, template, true, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                }
            }
        }
        return QuteCompletions.EMPTY_FUTURE_COMPLETION;
    }

    private CompletableFuture<CompletionList> doCompleteExpressionForMemberPart(Part part, Parts parts, Template template, boolean infixNotation, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, QuteNativeSettings nativeImagesSettings, CancelChecker cancelChecker) {
        int start = part != null ? part.getStart() : parts.getEnd();
        int end = part != null ? part.getEnd() : parts.getEnd();
        QuteProject project = template.getProject();
        if (project == null) {
            return QuteCompletions.EMPTY_FUTURE_COMPLETION;
        }
        Part previousPart = parts.getPreviousPart(part);
        return project.resolveJavaType(previousPart).thenApply(resolvedType -> {
            cancelChecker.checkCanceled();
            if (!QuteCompletableFutures.isValidJavaType(resolvedType)) {
                return QuteCompletions.EMPTY_COMPLETION;
            }
            return this.doCompleteForJavaTypeMembers((ResolvedJavaTypeInfo)resolvedType, start, end, template, project, infixNotation, completionSettings, formattingSettings, nativeImagesSettings);
        });
    }

    private CompletionList doCompleteForJavaTypeMembers(ResolvedJavaTypeInfo baseType, int start, int end, Template template, QuteProject project, boolean infixNotation, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, QuteNativeSettings nativeImagesSettings) {
        JavaTypeAccessibiltyRule javaTypeAccessibility;
        HashSet<CompletionItem> completionItems = new HashSet<CompletionItem>();
        Range range = QutePositionUtility.createRange(start, end, template);
        HashSet<String> existingProperties = new HashSet<String>();
        HashSet<String> existingMethodSignatures = new HashSet<String>();
        JavaTypeFilter filter = this.projectRegistry.getJavaTypeFilter(project.getUri(), nativeImagesSettings);
        JavaTypeAccessibiltyRule javaTypeAccessibiltyRule = javaTypeAccessibility = !filter.isInNativeMode() ? JavaTypeAccessibiltyRule.ALLOWED_WITHOUT_RESTRICTION : filter.getJavaTypeAccessibility(baseType, template.getJavaTypesSupportedInNativeMode());
        if (javaTypeAccessibility != null) {
            if (!infixNotation) {
                this.fillCompletionFields(baseType, javaTypeAccessibility, filter, range, project, existingProperties, completionItems);
            }
            this.fillCompletionMethods(baseType, javaTypeAccessibility, filter, range, project, infixNotation, completionSettings, formattingSettings, existingProperties, existingMethodSignatures, completionItems);
        }
        List<MethodValueResolver> resolvers = project.getResolversFor(baseType);
        for (MethodValueResolver method : resolvers) {
            if (!method.isValidName() || !QuteCompletionsForExpression.isValidInfixNotation(method, infixNotation)) continue;
            QuteCompletionsForExpression.fillCompletionMethod((JavaMethodInfo)method, javaTypeAccessibility, null, range, infixNotation, completionSettings, formattingSettings, completionItems);
        }
        CompletionList list = new CompletionList();
        list.setItems(completionItems.stream().collect(Collectors.toList()));
        return list;
    }

    private void fillCompletionFields(ResolvedJavaTypeInfo baseType, JavaTypeAccessibiltyRule javaTypeAccessibility, JavaTypeFilter filter, Range range, QuteProject project, Set<String> existingProperties, Set<CompletionItem> completionItems) {
        this.fillCompletionFields(baseType, javaTypeAccessibility, filter, range, project, existingProperties, completionItems, new HashSet<ResolvedJavaTypeInfo>());
    }

    private void fillCompletionFields(ResolvedJavaTypeInfo baseType, JavaTypeAccessibiltyRule javaTypeAccessibility, JavaTypeFilter filter, Range range, QuteProject project, Set<String> existingProperties, Set<CompletionItem> completionItems, Set<ResolvedJavaTypeInfo> visited) {
        List<String> extendedTypes;
        if (visited.contains(baseType)) {
            return;
        }
        visited.add(baseType);
        for (JavaFieldInfo field : baseType.getFields()) {
            String fieldName = field.getName();
            if (existingProperties.contains(fieldName)) continue;
            QuteCompletionsForExpression.fillCompletionField(field, javaTypeAccessibility, filter, range, completionItems);
            existingProperties.add(fieldName);
        }
        if (!QuteCompletionsForExpression.isIgnoreSuperclasses(baseType, javaTypeAccessibility, filter) && (extendedTypes = baseType.getExtendedTypes()) != null) {
            for (String extendedType : extendedTypes) {
                ResolvedJavaTypeInfo resolvedExtendedType = project.resolveJavaTypeSync(extendedType);
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedExtendedType)) continue;
                this.fillCompletionFields(resolvedExtendedType, javaTypeAccessibility, filter, range, project, existingProperties, completionItems, visited);
            }
        }
    }

    private static void fillCompletionField(JavaFieldInfo field, JavaTypeAccessibiltyRule javaTypeAccessibility, JavaTypeFilter filter, Range range, Set<CompletionItem> completionItems) {
        if (!JavaTypeAccessibiltyRule.ALLOWED_WITHOUT_RESTRICTION.equals(javaTypeAccessibility) && filter != null && filter.getJavaMemberAccessibility(field, javaTypeAccessibility) != JavaTypeFilter.JavaMemberAccessibility.ALLOWED) {
            return;
        }
        QuteCompletionsForExpression.fillCompletionField(field, null, false, range, completionItems);
    }

    private static CompletionItem fillCompletionField(JavaFieldInfo field, String namespace, boolean useNamespaceInTextEdit, Range range, Set<CompletionItem> completionItems) {
        String label = namespace != null ? namespace + ":" + field.getSimpleSignature() : field.getSimpleSignature();
        String insertText = useNamespaceInTextEdit && namespace != null ? namespace + ":" + field.getName() : field.getName();
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setFilterText(insertText);
        item.setKind(CompletionItemKind.Field);
        TextEdit textEdit = new TextEdit();
        textEdit.setRange(range);
        textEdit.setNewText(insertText);
        item.setTextEdit(Either.forLeft((Object)textEdit));
        completionItems.add(item);
        return item;
    }

    private void fillCompletionMethods(ResolvedJavaTypeInfo baseType, JavaTypeAccessibiltyRule javaTypeAccessibility, JavaTypeFilter filter, Range range, QuteProject project, boolean infixNotation, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, Set<String> existingProperties, Set<String> existingMethodSignatures, Set<CompletionItem> completionItems) {
        this.fillCompletionMethods(baseType, javaTypeAccessibility, filter, range, project, infixNotation, completionSettings, formattingSettings, existingProperties, existingMethodSignatures, completionItems, new HashSet<ResolvedJavaTypeInfo>());
    }

    private void fillCompletionMethods(ResolvedJavaTypeInfo baseType, JavaTypeAccessibiltyRule javaTypeAccessibility, JavaTypeFilter filter, Range range, QuteProject project, boolean infixNotation, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, Set<String> existingProperties, Set<String> existingMethodSignatures, Set<CompletionItem> completionItems, Set<ResolvedJavaTypeInfo> visited) {
        List<String> extendedTypes;
        if (visited.contains(baseType)) {
            return;
        }
        visited.add(baseType);
        for (JavaMethodInfo method : baseType.getMethods()) {
            String methodSignature;
            if (!QuteCompletionsForExpression.isValidInfixNotation(method, infixNotation) || existingMethodSignatures.contains(methodSignature = method.getSignature())) continue;
            existingMethodSignatures.add(methodSignature);
            String property = method.getGetterName();
            if (property != null && !existingProperties.contains(property)) {
                CompletionItem item = new CompletionItem();
                item.setLabel(property + " : " + method.getJavaElementSimpleType());
                item.setFilterText(property);
                item.setKind(CompletionItemKind.Property);
                TextEdit textEdit = new TextEdit();
                textEdit.setRange(range);
                textEdit.setNewText(property);
                item.setTextEdit(Either.forLeft((Object)textEdit));
                completionItems.add(item);
            }
            QuteCompletionsForExpression.fillCompletionMethod(method, javaTypeAccessibility, filter, range, infixNotation, completionSettings, formattingSettings, completionItems);
        }
        if (!QuteCompletionsForExpression.isIgnoreSuperclasses(baseType, javaTypeAccessibility, filter) && (extendedTypes = baseType.getExtendedTypes()) != null) {
            for (String extendedType : extendedTypes) {
                ResolvedJavaTypeInfo resolvedExtendedType = project.resolveJavaTypeSync(extendedType);
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedExtendedType)) continue;
                this.fillCompletionMethods(resolvedExtendedType, javaTypeAccessibility, filter, range, project, infixNotation, completionSettings, formattingSettings, existingProperties, existingMethodSignatures, completionItems, visited);
            }
        }
    }

    private void fillCaseOperators(CaseSection caseSection, boolean onlyMulti, Range range, Set<String> existingParameters, Set<CompletionItem> completionItems, boolean canSupportMarkdown) {
        for (CaseOperator operator : caseSection.getAllowedOperators()) {
            if (onlyMulti && !operator.isMulti()) continue;
            CompletionItem item = new CompletionItem();
            item.setLabel(operator.getName() + " : Operator");
            item.setFilterText(operator.getName());
            item.setKind(CompletionItemKind.Operator);
            item.setDocumentation(DocumentationUtils.getDocumentation(operator, canSupportMarkdown));
            TextEdit textEdit = new TextEdit();
            textEdit.setRange(range);
            textEdit.setNewText(operator.getName());
            item.setTextEdit(Either.forLeft((Object)textEdit));
            completionItems.add(item);
        }
    }

    private static boolean isIgnoreSuperclasses(ResolvedJavaTypeInfo baseType, JavaTypeAccessibiltyRule javaTypeAccessibility, JavaTypeFilter filter) {
        return filter != null && filter.isIgnoreSuperclasses(baseType, javaTypeAccessibility);
    }

    private static boolean isValidInfixNotation(JavaMethodInfo method, boolean infixNotation) {
        if (!infixNotation) {
            return true;
        }
        int nbParameters = method.getParameterslength();
        return nbParameters == 1;
    }

    private static void fillCompletionMethod(JavaMethodInfo method, JavaTypeAccessibiltyRule javaTypeAccessibility, JavaTypeFilter filter, Range range, boolean infixNotation, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, Set<CompletionItem> completionItems) {
        if (!JavaTypeAccessibiltyRule.ALLOWED_WITHOUT_RESTRICTION.equals(javaTypeAccessibility) && filter != null && filter.getJavaMemberAccessibility(method, javaTypeAccessibility) != JavaTypeFilter.JavaMemberAccessibility.ALLOWED) {
            return;
        }
        QuteCompletionsForExpression.fillCompletionMethod(method, null, false, range, infixNotation, completionSettings, formattingSettings, completionItems);
    }

    private static CompletionItem fillCompletionMethod(JavaMethodInfo method, String namespace, boolean useNamespaceInTextEdit, Range range, boolean infixNotation, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, Set<CompletionItem> completionItems) {
        String label = namespace != null ? namespace + ":" + method.getSimpleSignature() : method.getSimpleSignature();
        String filterText = namespace != null ? namespace + ":" + method.getMethodName() : method.getMethodName();
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setFilterText(filterText);
        item.setKind(method.isVirtual() ? CompletionItemKind.Function : CompletionItemKind.Method);
        item.setInsertTextFormat(completionSettings.isCompletionSnippetsSupported() ? InsertTextFormat.Snippet : InsertTextFormat.PlainText);
        TextEdit textEdit = new TextEdit();
        textEdit.setRange(range);
        Object insertText = QuteCompletionsForExpression.createMethodSnippet(method, infixNotation, completionSettings, formattingSettings);
        if (useNamespaceInTextEdit && namespace != null) {
            insertText = namespace + ":" + (String)insertText;
        }
        textEdit.setNewText((String)insertText);
        item.setTextEdit(Either.forLeft((Object)textEdit));
        completionItems.add(item);
        return item;
    }

    private static String createMethodSnippet(JavaMethodInfo method, boolean infixNotation, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings) {
        boolean snippetsSupported = completionSettings.isCompletionSnippetsSupported();
        String methodName = method.getMethodName();
        StringBuilder snippet = new StringBuilder();
        if ("*".equals(methodName)) {
            String parameterName;
            JavaParameterInfo firstParameter = method.getParameterAt(0);
            String string = parameterName = firstParameter != null ? firstParameter.getName() : methodName;
            if (snippetsSupported) {
                SnippetsBuilder.placeholders(1, parameterName, snippet);
            } else {
                snippet.append(parameterName);
            }
            if (snippetsSupported) {
                SnippetsBuilder.tabstops(0, snippet);
            }
        } else {
            snippet.append(methodName);
            if (method.hasParameters()) {
                int start = 0;
                if (method.isVirtual() && ((ValueResolver)((Object)method)).getNamespace() == null) {
                    ++start;
                }
                if (!infixNotation) {
                    snippet.append('(');
                } else {
                    snippet.append(' ');
                }
                int end = QuteCompletionsForExpression.getRequiredParametersSize(method);
                for (int i = start; i < end; ++i) {
                    if (i > start) {
                        snippet.append(", ");
                    }
                    JavaParameterInfo parameter = method.getParameterAt(i);
                    if (snippetsSupported) {
                        SnippetsBuilder.placeholders(i - start + 1, parameter.getName(), snippet);
                        continue;
                    }
                    snippet.append(parameter.getName());
                }
                if (!infixNotation) {
                    snippet.append(')');
                }
                if (snippetsSupported) {
                    SnippetsBuilder.tabstops(0, snippet);
                }
            }
        }
        return snippet.toString();
    }

    private static int getRequiredParametersSize(JavaMethodInfo method) {
        int nbParameters = method.getParameters().size();
        if (method.getJaxRsMethodKind() != null) {
            int nbRequiredParameters = 0;
            for (int i = 0; i < nbParameters; ++i) {
                JavaParameterInfo parameterInfo = method.getParameters().get(i);
                RestParam restParam = method.getRestParameter(parameterInfo.getName());
                if (restParam == null || restParam.getParameterKind() != JaxRsParamKind.PATH) continue;
                ++nbRequiredParameters;
            }
            return nbRequiredParameters;
        }
        return nbParameters;
    }

    private CompletableFuture<CompletionList> doCompleteExpressionForObjectPart(CompletionRequest completionRequest, Expression expression, String namespace, Node part, int offset, Template template, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, QuteNativeSettings nativeImagesSettings, CancelChecker cancelChecker) {
        boolean completionOnDataModel;
        int partStart = part != null && part.getKind() != NodeKind.Text ? (part.getKind() == NodeKind.ExpressionPart ? ((Part)part).getStartName() : part.getStart()) : offset;
        int partEnd = part != null && part.getKind() != NodeKind.Text ? part.getEnd() : offset;
        Range range = QutePositionUtility.createRange(partStart, partEnd, template);
        Section userTagSection = null;
        UserTag userTag = null;
        boolean bl = completionOnDataModel = !QuteCompletionsForExpression.isInCaseSection(expression);
        if (completionOnDataModel) {
            userTagSection = QuteCompletionsForExpression.getUserTagSection(expression);
            if (userTagSection != null) {
                QuteProject project = template.getProject();
                if (project != null) {
                    String tagName = userTagSection.getTag();
                    userTag = project.findUserTag(tagName);
                }
                completionOnDataModel = QuteCompletionsForExpression.isInUserTagItParameter(userTagSection, userTag, completionRequest);
            } else {
                completionOnDataModel = true;
            }
        }
        HashSet<CompletionItem> completionItems = new HashSet<CompletionItem>();
        if (completionOnDataModel) {
            this.doCompleteNamespaceResolvers(namespace, template, range, completionSettings, formattingSettings, completionItems);
        }
        if (namespace == null) {
            TextEdit textEdit;
            CompletionItem item;
            char previous;
            if (completionOnDataModel) {
                this.doCompleteExpressionForObjectPartWithGlobalVariables(template, range, completionItems);
                this.doCompleteExpressionForObjectPartWithParameterAlias(template, range, completionItems);
                this.doCompleteExpressionForObjectPartWithCheckedTemplate(template, range, completionItems);
            }
            HashSet<String> existingVars = new HashSet<String>();
            this.doCompleteExpressionForObjectPartWithParentNodes(part, expression != null ? expression : part, range, offset, template, existingVars, completionSettings, formattingSettings, nativeImagesSettings, completionItems);
            if (completionRequest != null && (previous = template.getText().charAt(offset - 1)) == '#') {
                this.completionForTagSection.doCompleteTagSection(completionRequest, "#", completionSettings, formattingSettings, cancelChecker, completionItems);
            }
            if (userTag != null && userTagSection != null) {
                Collection<UserTagParameter> parameters = userTag.getParameters();
                for (UserTagParameter parameter : parameters) {
                    String paramName = parameter.getName();
                    if ("it".equals(paramName) || "nested-content".equals(paramName) || userTagSection.hasParameter(paramName)) continue;
                    item = new CompletionItem();
                    item.setLabel(paramName);
                    item.setKind(CompletionItemKind.Property);
                    textEdit = new TextEdit(range, QuteCompletionsForExpression.createUserTagParameterSnippet(parameter, completionSettings));
                    item.setTextEdit(Either.forLeft((Object)textEdit));
                    item.setInsertTextFormat(completionSettings.isCompletionSnippetsSupported() ? InsertTextFormat.Snippet : InsertTextFormat.PlainText);
                    completionItems.add(item);
                }
            }
            if (UserTagUtils.isUserTag(template)) {
                Collection<SectionMetadata> metadatas = UserTagUtils.getSpecialKeys();
                for (SectionMetadata metadata : metadatas) {
                    String name = metadata.getName();
                    if (existingVars.contains(name)) continue;
                    existingVars.add(name);
                    item = new CompletionItem();
                    item.setLabel(name);
                    item.setKind(CompletionItemKind.Keyword);
                    item.setSortText("Za" + name);
                    textEdit = new TextEdit(range, name);
                    item.setTextEdit(Either.forLeft((Object)textEdit));
                    item.setDetail(metadata.getDescription());
                    completionItems.add(item);
                }
            }
        }
        CompletionList list = new CompletionList();
        list.setItems(completionItems.stream().collect(Collectors.toList()));
        return CompletableFuture.completedFuture(list);
    }

    private static String createUserTagParameterSnippet(UserTagParameter parameter, QuteCompletionSettings completionSettings) {
        StringBuilder snippet = new StringBuilder();
        boolean completionSnippetsSupported = completionSettings.isCompletionSnippetsSupported();
        UserTag.generateUserTagParameter(parameter, completionSnippetsSupported, 1, snippet);
        if (completionSnippetsSupported) {
            SnippetsBuilder.tabstops(0, snippet);
        }
        return snippet.toString();
    }

    private static Section getUserTagSection(Expression expression) {
        if (expression == null) {
            return null;
        }
        Section section = expression.getOwnerSection();
        if (section != null && section.getSectionKind() == SectionKind.CUSTOM) {
            return section;
        }
        return null;
    }

    private static boolean isInUserTagItParameter(Section userTagSection, UserTag userTag, CompletionRequest completionRequest) {
        if (userTag == null) {
            return false;
        }
        UserTagParameter it = userTag.findParameter("it");
        if (it == null) {
            return false;
        }
        List<Parameter> parameters = userTagSection.getParameters();
        for (Parameter parameter : parameters) {
            if (parameter.hasValueAssigned()) continue;
            return completionRequest == null || parameter.isInName(completionRequest.getOffset());
        }
        return true;
    }

    private static boolean isInCaseSection(Expression expression) {
        return expression != null && expression.getOwnerSection() != null && Section.isCaseSection(expression.getOwnerSection());
    }

    private void doCompleteExpressionForObjectPartWithGlobalVariables(Template template, Range range, Set<CompletionItem> completionItems) {
        QuteProject project = template.getProject();
        if (project == null) {
            return;
        }
        List globalVariables = project.getGlobalVariables().getNow(null);
        if (globalVariables != null) {
            for (ValueResolver globalVariable : globalVariables) {
                String name = globalVariable.getNamed();
                if (name == null) {
                    name = globalVariable.getName();
                }
                CompletionItem item = new CompletionItem();
                item.setLabel(name);
                item.setKind(QuteCompletionsForExpression.getCompletionKind(globalVariable));
                TextEdit textEdit = new TextEdit(range, name);
                item.setTextEdit(Either.forLeft((Object)textEdit));
                completionItems.add(item);
            }
        }
    }

    private static CompletionItemKind getCompletionKind(ValueResolver globalVariable) {
        switch (globalVariable.getJavaElementKind()) {
            case FIELD: {
                return CompletionItemKind.Field;
            }
            case METHOD: {
                return CompletionItemKind.Method;
            }
            case TYPE: {
                return CompletionItemKind.Class;
            }
            case PARAMETER: {
                return CompletionItemKind.TypeParameter;
            }
        }
        return CompletionItemKind.Class;
    }

    public void doCompleteNamespaceResolvers(String namespace, Template template, Range range, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, Set<CompletionItem> completionItems) {
        if ("data".equals(namespace)) {
            this.doCompleteExpressionForObjectPartWithParameterAlias(template, range, completionItems);
            this.doCompleteExpressionForObjectPartWithCheckedTemplate(template, range, completionItems);
            return;
        }
        QuteProject project = template.getProject();
        if (project == null) {
            return;
        }
        HashSet<String> existingResovers = new HashSet<String>();
        List<ValueResolver> namespaceResolvers = project.getNamespaceResolvers(namespace);
        for (ValueResolver resolver : namespaceResolvers) {
            CompletionItem item;
            boolean useNamespaceInTextEdit = namespace == null;
            String named = resolver.getNamed();
            if (named != null) {
                Object label = useNamespaceInTextEdit ? resolver.getNamespace() + ":" + named : named;
                if (existingResovers.contains(label)) continue;
                existingResovers.add((String)label);
                item = new CompletionItem();
                item.setLabel((String)label);
                item.setFilterText((String)label);
                item.setKind(CompletionItemKind.Field);
                TextEdit textEdit = new TextEdit();
                textEdit.setRange(range);
                textEdit.setNewText((String)label);
                item.setTextEdit(Either.forLeft((Object)textEdit));
                item.setSortText("Zb" + item.getLabel());
                completionItems.add(item);
                continue;
            }
            switch (resolver.getJavaElementKind()) {
                case METHOD: {
                    MethodValueResolver method = (MethodValueResolver)resolver;
                    item = QuteCompletionsForExpression.fillCompletionMethod((JavaMethodInfo)method, method.getNamespace(), useNamespaceInTextEdit, range, false, completionSettings, formattingSettings, completionItems);
                    item.setKind(CompletionItemKind.Function);
                    item.setSortText("Zc" + item.getLabel());
                    break;
                }
                case FIELD: {
                    FieldValueResolver field = (FieldValueResolver)resolver;
                    item = QuteCompletionsForExpression.fillCompletionField((JavaFieldInfo)field, field.getNamespace(), namespace == null, range, completionItems);
                    item.setKind(CompletionItemKind.Field);
                    item.setSortText("Zb" + item.getLabel());
                    break;
                }
            }
        }
    }

    private CompletableFuture<Void> doCompleteExpressionForObjectPartWithParentNodes(Node part, Node node, Range range, int offset, Template template, Set<String> existingVars, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, QuteNativeSettings nativeImagesSettings, Set<CompletionItem> completionItems) {
        Section parentSection;
        Section section = parentSection = node != null ? node.getParentSection() : null;
        if (parentSection == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (parentSection.getKind() == NodeKind.Section) {
            LoopSection iterableSection;
            boolean collect = true;
            if ((parentSection.getSectionKind() == SectionKind.FOR || parentSection.getSectionKind() == SectionKind.EACH) && (iterableSection = (LoopSection)parentSection).isInElseBlock(offset)) {
                collect = false;
            }
            if (collect) {
                List<SectionMetadata> metadatas = parentSection.getMetadata();
                for (SectionMetadata metadata : metadatas) {
                    String name = metadata.getName();
                    if (existingVars.contains(name)) continue;
                    existingVars.add(name);
                    CompletionItem item = new CompletionItem();
                    item.setLabel(name);
                    item.setKind(CompletionItemKind.Keyword);
                    item.setSortText("Za" + name);
                    TextEdit textEdit = new TextEdit(range, name);
                    item.setTextEdit(Either.forLeft((Object)textEdit));
                    item.setDetail(metadata.getDescription());
                    completionItems.add(item);
                }
                block0 : switch (parentSection.getSectionKind()) {
                    case EACH: 
                    case FOR: {
                        LoopSection iterableSection2 = (LoopSection)parentSection;
                        String alias = iterableSection2.getAlias();
                        if (StringUtils.isEmpty(alias) || existingVars.contains(alias)) break;
                        existingVars.add(alias);
                        CompletionItem item = new CompletionItem();
                        item.setLabel(alias);
                        item.setKind(CompletionItemKind.Reference);
                        TextEdit textEdit = new TextEdit(range, alias);
                        item.setTextEdit(Either.forLeft((Object)textEdit));
                        completionItems.add(item);
                        break;
                    }
                    case LET: 
                    case SET: {
                        List<Parameter> parameters = parentSection.getParameters();
                        if (parameters == null) break;
                        for (Parameter parameter : parameters) {
                            String parameterName = parameter.getName();
                            if (existingVars.contains(parameterName)) continue;
                            existingVars.add(parameterName);
                            CompletionItem item = new CompletionItem();
                            item.setLabel(parameterName);
                            item.setKind(CompletionItemKind.Reference);
                            TextEdit textEdit = new TextEdit(range, parameterName);
                            item.setTextEdit(Either.forLeft((Object)textEdit));
                            completionItems.add(item);
                        }
                        break;
                    }
                    case IF: {
                        List<Parameter> parameters = parentSection.getParameters();
                        if (parameters == null) break;
                        for (Parameter parameter : parameters) {
                            String parameterName;
                            if (!parameter.isOptional() || existingVars.contains(parameterName = parameter.getName())) continue;
                            existingVars.add(parameterName);
                            CompletionItem item = new CompletionItem();
                            item.setLabel(parameterName);
                            item.setKind(CompletionItemKind.Reference);
                            TextEdit textEdit = new TextEdit(range, parameterName);
                            item.setTextEdit(Either.forLeft((Object)textEdit));
                            completionItems.add(item);
                        }
                        break;
                    }
                    case WITH: {
                        QuteProject project;
                        ResolvedJavaTypeInfo withJavaTypeInfo;
                        Parameter object = ((WithSection)parentSection).getObjectParameter();
                        if (object == null || (withJavaTypeInfo = (ResolvedJavaTypeInfo)(project = template.getProject()).resolveJavaType(object).getNow(null)) == null) break;
                        JavaTypeFilter filter = this.projectRegistry.getJavaTypeFilter(project.getUri(), nativeImagesSettings);
                        JavaTypeAccessibiltyRule javaTypeAccessibility = filter.getJavaTypeAccessibility(withJavaTypeInfo, template.getJavaTypesSupportedInNativeMode());
                        this.fillCompletionFields(withJavaTypeInfo, javaTypeAccessibility, filter, range, project, existingVars, completionItems);
                        this.fillCompletionMethods(withJavaTypeInfo, javaTypeAccessibility, filter, range, project, false, completionSettings, formattingSettings, existingVars, new HashSet<String>(), completionItems);
                        break;
                    }
                    case WHEN: 
                    case SWITCH: {
                        ResolvedJavaTypeInfo whenJavaType;
                        QuteProject project;
                        Expression expression;
                        if (node.getKind() != NodeKind.Expression || !Section.isCaseSection((expression = (Expression)node).getOwnerSection())) break;
                        Parameter triggeredParameter = expression.getOwnerParameter();
                        CaseSection caseSection = (CaseSection)expression.getOwnerSection();
                        Parameter value = ((WhenSection)parentSection).getValueParameter();
                        if (value == null || (project = template.getProject()) == null || QuteCompletableFutures.isResolvingJavaTypeOrNull(whenJavaType = project.resolveJavaTypeSync(value)) || !whenJavaType.isEnum()) break;
                        JavaTypeFilter filter = this.projectRegistry.getJavaTypeFilter(project.getUri(), nativeImagesSettings);
                        JavaTypeAccessibiltyRule javaTypeAccessibility = filter.getJavaTypeAccessibility(whenJavaType, template.getJavaTypesSupportedInNativeMode());
                        CaseSection.CompletionCaseResult result = caseSection.getCompletionCaseResultAt(offset, triggeredParameter);
                        HashSet<String> caseExistingVars = new HashSet<String>(existingVars);
                        for (Parameter parameter : caseSection.getParameters()) {
                            caseExistingVars.add(parameter.getName());
                        }
                        boolean canSupportMarkdown = completionSettings.canSupportMarkupKind("markdown");
                        switch (result) {
                            case ALL_OPERATOR_AND_FIELD: {
                                this.fillCaseOperators(caseSection, false, range, caseExistingVars, completionItems, canSupportMarkdown);
                                this.fillCompletionFields(whenJavaType, javaTypeAccessibility, filter, range, project, caseExistingVars, completionItems);
                                break block0;
                            }
                            case ALL_OPERATOR: {
                                this.fillCaseOperators(caseSection, false, range, caseExistingVars, completionItems, canSupportMarkdown);
                                break block0;
                            }
                            case FIELD_ONLY: {
                                this.fillCompletionFields(whenJavaType, javaTypeAccessibility, filter, range, project, caseExistingVars, completionItems);
                                break block0;
                            }
                            case MULTI_OPERATOR_ONLY: {
                                this.fillCaseOperators(caseSection, true, range, caseExistingVars, completionItems, canSupportMarkdown);
                                break block0;
                            }
                        }
                    }
                }
            }
        }
        this.doCompleteExpressionForObjectPartWithParentNodes(part, parentSection, range, offset, template, existingVars, completionSettings, formattingSettings, nativeImagesSettings, completionItems);
        return CompletableFuture.completedFuture(null);
    }

    private void doCompleteExpressionForObjectPartWithParameterAlias(Template template, Range range, Set<CompletionItem> completionItems) {
        template.getChildren().stream().filter(n -> n.getKind() == NodeKind.ParameterDeclaration).map(n -> ((ParameterDeclaration)n).getAlias()).filter(alias -> alias != null).forEach(alias -> {
            CompletionItem item = new CompletionItem();
            item.setLabel(alias);
            item.setKind(CompletionItemKind.Reference);
            TextEdit textEdit = new TextEdit(range, alias);
            item.setTextEdit(Either.forLeft((Object)textEdit));
            completionItems.add(item);
        });
    }

    private void doCompleteExpressionForObjectPartWithCheckedTemplate(Template template, Range range, Set<CompletionItem> completionItems) {
        QuteProject project = template.getProject();
        if (project == null) {
            return;
        }
        ExtendedDataModelTemplate dataModel = project.getDataModelTemplate(template).getNow(null);
        if (dataModel == null || dataModel.getParameters() == null) {
            return;
        }
        for (ExtendedDataModelParameter parameter : dataModel.getParameters()) {
            CompletionItem item = new CompletionItem();
            item.setLabel(parameter.getKey());
            item.setKind(CompletionItemKind.Reference);
            TextEdit textEdit = new TextEdit(range, parameter.getKey());
            item.setTextEdit(Either.forLeft((Object)textEdit));
            completionItems.add(item);
        }
    }
}

