/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.completions;

import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.JavaTypeKind;
import com.redhat.qute.commons.QuteJavaTypesParams;
import com.redhat.qute.ls.commons.snippets.SnippetsBuilder;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.services.QuteCompletions;
import com.redhat.qute.settings.QuteCompletionSettings;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class QuteCompletionsForParameterDeclaration {
    private final QuteProjectRegistry projectRegistry;
    private CompletionItemDefaults completionItemDefaults;

    public QuteCompletionsForParameterDeclaration(QuteProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    public CompletableFuture<CompletionList> doCollectJavaClassesSuggestions(ParameterDeclaration parameterDeclaration, Template template, int offset, QuteCompletionSettings completionSettings, CancelChecker cancelChecker) {
        ParameterDeclaration.JavaTypeRangeOffset rangeOffset;
        QuteProject project = template.getProject();
        if (project != null && parameterDeclaration.isInJavaTypeName(offset) && (rangeOffset = parameterDeclaration.getJavaTypeNameRange(offset)) != null) {
            this.initializeCompletionListItemDefaults(rangeOffset, template, completionSettings);
            boolean hasAlias = parameterDeclaration.hasAlias();
            boolean closed = parameterDeclaration.isClosed();
            String patternTypeName = template.getText(rangeOffset.getStart(), offset);
            return this.collectJavaClassesSuggestions(patternTypeName, hasAlias, closed, rangeOffset, project, template, completionSettings, cancelChecker);
        }
        return QuteCompletions.EMPTY_FUTURE_COMPLETION;
    }

    private CompletableFuture<CompletionList> collectJavaClassesSuggestions(String pattern, boolean hasAlias, boolean closed, ParameterDeclaration.JavaTypeRangeOffset rangeOffset, QuteProject project, Template template, QuteCompletionSettings completionSettings, CancelChecker cancelChecker) {
        QuteJavaTypesParams params = new QuteJavaTypesParams(pattern, project.getUri());
        return this.projectRegistry.getJavaTypes(params).thenApply(result -> {
            cancelChecker.checkCanceled();
            if (result == null) {
                return null;
            }
            CompletionList list = new CompletionList();
            list.setItems(new ArrayList());
            Range range = QutePositionUtility.createRange(rangeOffset, template);
            for (JavaTypeInfo typeInfo : result) {
                String fullClassName = typeInfo.getName();
                CompletionItem item = new CompletionItem();
                item.setLabel(typeInfo.getSignature());
                StringBuilder insertText = new StringBuilder(fullClassName);
                if (typeInfo.getJavaTypeKind() == JavaTypeKind.Package) {
                    item.setKind(CompletionItemKind.Module);
                    if (rangeOffset.isInGeneric() && !rangeOffset.isGenericClosed()) {
                        insertText.append('>');
                    }
                } else {
                    item.setKind(typeInfo.getJavaTypeKind() == JavaTypeKind.Interface ? CompletionItemKind.Interface : CompletionItemKind.Class);
                    int snippetIndex = 1;
                    int index = fullClassName.lastIndexOf(46);
                    String typeName = index != -1 ? fullClassName.substring(index + 1, fullClassName.length()) : fullClassName;
                    List<JavaParameterInfo> parameters = typeInfo.getTypeParameters();
                    if (!parameters.isEmpty()) {
                        insertText.append('<');
                        for (int i = 0; i < parameters.size(); ++i) {
                            if (i > 0) {
                                insertText.append(',');
                            }
                            String parameterType = parameters.get(i).getType();
                            if (completionSettings.isCompletionSnippetsSupported()) {
                                SnippetsBuilder.placeholders(snippetIndex++, parameterType, insertText);
                                continue;
                            }
                            insertText.append(parameterType);
                        }
                        insertText.append('>');
                    } else if (rangeOffset.isInGeneric() && !rangeOffset.isGenericClosed()) {
                        insertText.append('>');
                    }
                    if (!hasAlias) {
                        insertText.append(' ');
                    }
                    String alias = String.valueOf(typeName.charAt(0)).toLowerCase() + typeName.substring(1, typeName.length());
                    if (completionSettings.isCompletionSnippetsSupported()) {
                        if (!hasAlias) {
                            SnippetsBuilder.placeholders(snippetIndex++, alias, insertText);
                            if (!closed) {
                                insertText.append("}");
                            }
                        }
                        SnippetsBuilder.tabstops(0, insertText);
                    } else if (!hasAlias) {
                        insertText.append(alias);
                        if (!closed) {
                            insertText.append("}");
                        }
                    }
                }
                if (this.completionItemDefaults.getEditRange() != null && range.equals(this.completionItemDefaults.getEditRange().getLeft())) {
                    item.setTextEditText(insertText.toString());
                } else {
                    item.setTextEdit(Either.forLeft((Object)new TextEdit(range, insertText.toString())));
                }
                if (this.completionItemDefaults.getInsertTextFormat() == null) {
                    item.setInsertTextFormat(completionSettings.isCompletionSnippetsSupported() ? InsertTextFormat.Snippet : InsertTextFormat.PlainText);
                }
                list.getItems().add(item);
            }
            list.setItemDefaults(this.completionItemDefaults);
            return list;
        });
    }

    private void initializeCompletionListItemDefaults(ParameterDeclaration.JavaTypeRangeOffset rangeOffset, Template template, QuteCompletionSettings completionSettings) {
        this.completionItemDefaults = new CompletionItemDefaults();
        Range range = QutePositionUtility.createRange(rangeOffset, template);
        if (completionSettings.isCompletionListItemDefaultsSupport("editRange")) {
            this.completionItemDefaults.setEditRange(Either.forLeft((Object)range));
        }
        if (completionSettings.isCompletionListItemDefaultsSupport("insertTextFormat")) {
            this.completionItemDefaults.setInsertTextFormat(completionSettings.isCompletionSnippetsSupported() ? InsertTextFormat.Snippet : InsertTextFormat.PlainText);
        }
    }
}

