/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.completions.tags;

import com.redhat.qute.ls.commons.snippets.Snippet;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.services.completions.CompletionRequest;
import com.redhat.qute.services.completions.tags.QuteCompletionsForSnippets;
import com.redhat.qute.settings.QuteCompletionSettings;
import com.redhat.qute.settings.QuteFormattingSettings;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteCompletionForTagSection {
    private final QuteCompletionsForSnippets<Snippet> completionsForSnippets;

    public QuteCompletionForTagSection(QuteCompletionsForSnippets<Snippet> completionsForSnippets) {
        this.completionsForSnippets = completionsForSnippets;
    }

    public void doCompleteTagSection(CompletionRequest completionRequest, String filterPrefix, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, CancelChecker cancelChecker, Set<CompletionItem> completionItems) {
        Template template = completionRequest.getTemplate();
        QuteProject project = template.getProject();
        if (project != null) {
            project.collectUserTagSuggestions(completionRequest, filterPrefix, "}", completionItems);
        }
        this.completionsForSnippets.collectSnippetSuggestions(completionRequest, filterPrefix, "}", completionItems);
    }

    public CompletableFuture<CompletionList> doCompleteTagSection(CompletionRequest completionRequest, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, CancelChecker cancelChecker) {
        HashSet<CompletionItem> completionItems = new HashSet<CompletionItem>();
        this.doCompleteTagSection(completionRequest, "{#", completionSettings, formattingSettings, cancelChecker, completionItems);
        CompletionList list = new CompletionList();
        list.setItems(completionItems.stream().collect(Collectors.toList()));
        return CompletableFuture.completedFuture(list);
    }
}

