/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.completions.tags;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.LineIndentInfo;
import com.redhat.qute.ls.commons.snippets.Snippet;
import com.redhat.qute.ls.commons.snippets.SnippetRegistry;
import com.redhat.qute.ls.commons.snippets.SnippetRegistryProvider;
import com.redhat.qute.ls.commons.snippets.SnippetsBuilder;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.IncludeSection;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.services.completions.CompletionRequest;
import com.redhat.qute.services.completions.tags.QuteSnippetContentProvider;
import com.redhat.qute.services.snippets.AbstractQuteSnippetContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.InsertTextMode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class QuteCompletionsForSnippets<T extends Snippet> {
    private static final Logger LOGGER = Logger.getLogger(QuteCompletionsForSnippets.class.getName());
    private SnippetRegistry<T> snippetRegistry;
    private final boolean loadDefault;
    private final SnippetRegistryProvider<T> snippetRegistryProvider;

    public QuteCompletionsForSnippets(SnippetRegistryProvider<T> snippetRegistryProvider) {
        this(snippetRegistryProvider, false);
    }

    public QuteCompletionsForSnippets() {
        this(true);
    }

    public QuteCompletionsForSnippets(boolean loadDefault) {
        this(null, loadDefault);
    }

    private QuteCompletionsForSnippets(SnippetRegistryProvider<T> snippetRegistryProvider, boolean loadDefault) {
        this.loadDefault = loadDefault;
        this.snippetRegistryProvider = snippetRegistryProvider;
    }

    public void collectSnippetSuggestions(CompletionRequest completionRequest, String prefixFilter, String suffixToFind, Set<CompletionItem> completionItems) {
        Node node = completionRequest.getNode();
        int offset = completionRequest.getOffset();
        Template template = completionRequest.getTemplate();
        Section section = QuteCompletionsForSnippets.getCoveredStartSection(node, offset);
        if (section != null && section.hasEndTag() && !section.hasEmptyEndTag()) {
            return;
        }
        try {
            QuteSnippetContentProvider contentProvider = new QuteSnippetContentProvider(node, section, offset, template);
            Range replaceRange = contentProvider.getReplaceRange();
            int lineNumber = replaceRange.getStart().getLine();
            String lineDelimiter = null;
            String whitespacesIndent = null;
            if (!completionRequest.isInsertTextModeAdjustIndentationSupported()) {
                LineIndentInfo indentInfo = template.lineIndentInfo(lineNumber);
                lineDelimiter = indentInfo.getLineDelimiter();
                whitespacesIndent = indentInfo.getWhitespacesIndent();
            } else {
                lineDelimiter = template.lineDelimiter(lineNumber);
            }
            InsertTextMode defaultInsertTextMode = completionRequest.getDefaultInsertTextMode();
            List<CompletionItem> snippets = this.getSnippetRegistry().getCompletionItems(replaceRange, lineDelimiter, whitespacesIndent, defaultInsertTextMode, completionRequest.canSupportMarkupKind("markdown"), completionRequest.isCompletionSnippetsSupported(), (context, model) -> {
                if (context instanceof AbstractQuteSnippetContext) {
                    return ((AbstractQuteSnippetContext)context).isMatch(completionRequest, (Map<String, String>)model);
                }
                return false;
            }, contentProvider, suffixToFind, prefixFilter, contentProvider);
            completionItems.addAll(snippets);
            Range range = replaceRange;
            Position end = contentProvider.findSuffixPosition(suffixToFind);
            if (end != null) {
                range = new Range(replaceRange.getStart(), end);
            }
            this.collectInsertParameterSuggestions(completionRequest, range, prefixFilter, suffixToFind, whitespacesIndent, defaultInsertTextMode, completionItems);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In QuteCompletions, collectSnippetSuggestions position error", e);
        }
    }

    private void collectInsertParameterSuggestions(CompletionRequest completionRequest, Range replaceRange, String prefixFilter, String suffixToFind, String whitespacesIndent, InsertTextMode defaultInsertTextMode, Set<CompletionItem> completionItems) {
        Node node = completionRequest.getNode();
        if (node == null) {
            return;
        }
        QuteProject project = completionRequest.getTemplate().getProject();
        if (project == null) {
            return;
        }
        for (Node parent = node.getParent(); parent != null; parent = parent.getParent()) {
            IncludeSection includeSection;
            List<Parameter> parameters;
            Section parentSection;
            if (parent.getKind() != NodeKind.Section || (parentSection = (Section)parent).getSectionKind() != SectionKind.INCLUDE || (parameters = project.findInsertTagParameter((includeSection = (IncludeSection)parentSection).getReferencedTemplateId(), "@all")) == null) continue;
            for (Parameter parameter : parameters) {
                String tagName = parameter.getName();
                CompletionItem item = new CompletionItem();
                item.setKind(CompletionItemKind.Reference);
                item.setLabel(tagName);
                item.setInsertTextFormat(completionRequest.isCompletionSnippetsSupported() ? InsertTextFormat.Snippet : InsertTextFormat.PlainText);
                SnippetRegistry.updateInsertTextMode(item, whitespacesIndent, defaultInsertTextMode);
                item.setFilterText(prefixFilter + tagName);
                StringBuilder insertText = new StringBuilder("{#");
                insertText.append(parameter.getName());
                insertText.append("}");
                if (completionRequest.isCompletionSnippetsSupported()) {
                    SnippetsBuilder.tabstops(1, insertText);
                }
                insertText.append("{/");
                insertText.append(parameter.getName());
                insertText.append("}");
                if (completionRequest.isCompletionSnippetsSupported()) {
                    SnippetsBuilder.tabstops(0, insertText);
                }
                item.setTextEdit(Either.forLeft((Object)new TextEdit(replaceRange, insertText.toString())));
                completionItems.add(item);
            }
        }
    }

    private static Section getCoveredStartSection(Node node, int offset) {
        if (node == null || node.getKind() != NodeKind.Section) {
            return null;
        }
        Section section = (Section)node;
        if (section.isInStartTagName(offset)) {
            return section;
        }
        return null;
    }

    protected SnippetRegistry<T> getSnippetRegistry() {
        if (this.snippetRegistryProvider != null) {
            return this.snippetRegistryProvider.getSnippetRegistry();
        }
        if (this.snippetRegistry == null) {
            this.snippetRegistry = new SnippetRegistry(null, this.loadDefault);
        }
        return this.snippetRegistry;
    }
}

