/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.completions.tags;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.snippets.DefaultSnippetContentProvider;
import com.redhat.qute.ls.commons.snippets.ISuffixPositionProvider;
import com.redhat.qute.ls.commons.snippets.Snippet;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class QuteSnippetContentProvider
extends DefaultSnippetContentProvider
implements ISuffixPositionProvider {
    private boolean hasParameters;
    private Range replaceRange;
    private Position startTagClosePosition;
    private boolean generateOnlyFirstPartOfSection;

    public QuteSnippetContentProvider(Node node, Section section, int offset, Template template) throws BadLocationException {
        if (section != null) {
            this.replaceRange = QutePositionUtility.selectStartTagName(section, true);
            boolean bl = this.hasParameters = !section.getParameters().isEmpty();
            if (!this.hasParameters && section.isStartTagClosed()) {
                this.startTagClosePosition = template.positionAt(section.getStartTagCloseOffset() + 1);
            }
            this.generateOnlyFirstPartOfSection = section.hasEndTag();
            if (this.generateOnlyFirstPartOfSection && section.hasEmptyEndTag()) {
                for (Section parentSection = section.getParentSection(); parentSection != null; parentSection = parentSection.getParentSection()) {
                    if (parentSection.hasEndTag()) continue;
                    this.generateOnlyFirstPartOfSection = false;
                    break;
                }
            }
        }
        if (this.replaceRange == null) {
            String text = template.getText();
            int endExpr = offset;
            int fromSearchExpr = QuteSnippetContentProvider.getExprLimitStart(node, endExpr);
            int startExpr = QuteSnippetContentProvider.getExprStart(text, fromSearchExpr, endExpr);
            this.replaceRange = QuteSnippetContentProvider.getReplaceRange(startExpr, endExpr, offset, template);
        }
    }

    @Override
    public Position findSuffixPosition(String suffix) {
        return this.startTagClosePosition;
    }

    @Override
    public String getInsertText(Snippet snippet, Map<String, String> model, boolean replace, String lineDelimiter, String whitespacesIndent) {
        List<String> body = snippet.getBody();
        if (!this.generateOnlyFirstPartOfSection || body.size() <= 1) {
            return super.getInsertText(snippet, model, replace, lineDelimiter, whitespacesIndent);
        }
        if (this.hasParameters) {
            String sectionTag = snippet.getLabel();
            return "{#" + sectionTag;
        }
        String firstLine = body.get(0);
        return DefaultSnippetContentProvider.merge(firstLine, model, replace);
    }

    public Range getReplaceRange() {
        return this.replaceRange;
    }

    private static int getExprStart(String value, int from, int to) {
        int index;
        if (to == 0) {
            return to;
        }
        for (index = to - 1; index > 0; --index) {
            if (Character.isWhitespace(value.charAt(index))) {
                return index + 1;
            }
            if (index > from) continue;
            return from;
        }
        return index;
    }

    private static int getExprLimitStart(Node currentNode, int offset) {
        if (currentNode == null) {
            return 0;
        }
        return currentNode.getStart();
    }

    private static Range getReplaceRange(int replaceStart, int replaceEnd, int offset, Template template) throws BadLocationException {
        if (replaceStart > offset) {
            replaceStart = offset;
        }
        return QutePositionUtility.createRange(replaceStart, replaceEnd, template);
    }
}

