/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.diagnostics;

import com.redhat.qute.parser.html.scanner.HtmlScanner;
import com.redhat.qute.parser.html.scanner.TokenType;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.Text;
import java.util.ArrayList;
import java.util.List;

public class CollectHtmlInputNamesVisitor
extends ASTVisitor {
    private static final String INPUT_ELEMENT = "input";
    private static final String NAME_ATTR = "name";
    private final List<String> htmlInputNames = new ArrayList<String>();

    public List<String> getHtmlInputNames() {
        return this.htmlInputNames;
    }

    @Override
    public boolean visit(Text text) {
        String templateText = text.getOwnerTemplate().getText();
        HtmlScanner scanner = HtmlScanner.createScanner(templateText, text.getStart(), text.getEnd());
        TokenType token = (TokenType)((Object)scanner.scan());
        String currentAttrName = null;
        String currentElementName = null;
        while (token != TokenType.EOS) {
            switch (token) {
                case ElementName: {
                    currentElementName = scanner.getTokenText();
                    break;
                }
                case AttributeName: {
                    if (currentElementName == null || !INPUT_ELEMENT.equals(currentElementName)) break;
                    currentAttrName = scanner.getTokenText();
                    break;
                }
                case AttributeValue: {
                    if (currentAttrName == null || !NAME_ATTR.equals(currentAttrName)) break;
                    StringBuilder inputName = new StringBuilder();
                    for (int i = scanner.getTokenOffset(); i < scanner.getTokenEnd(); ++i) {
                        char c = templateText.charAt(i);
                        if (c == '\'' || c == '\"') continue;
                        inputName.append(c);
                    }
                    this.htmlInputNames.add(inputName.toString());
                    break;
                }
            }
            token = (TokenType)((Object)scanner.scan());
        }
        return true;
    }
}

