/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.diagnostics;

import com.redhat.qute.parser.validator.IQuteErrorCode;
import com.redhat.qute.services.diagnostics.JavaBaseTypeOfPartData;
import com.redhat.qute.utils.JSONUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;

public class DiagnosticDataFactory {
    public static JavaBaseTypeOfPartData getJavaBaseTypeOfPartData(Diagnostic diagnostic) {
        if (diagnostic.getData() == null) {
            return null;
        }
        return JSONUtility.toModel(diagnostic.getData(), JavaBaseTypeOfPartData.class);
    }

    public static Diagnostic createDiagnostic(Range range, DiagnosticSeverity severity, IQuteErrorCode errorCode, Object ... arguments) {
        String message = errorCode.getMessage(arguments);
        return DiagnosticDataFactory.createDiagnostic(range, message, severity, errorCode);
    }

    public static Diagnostic createDiagnostic(Range range, String message, DiagnosticSeverity severity, IQuteErrorCode errorCode) {
        Diagnostic diagnostic = new Diagnostic(range, message, severity, "qute", errorCode != null ? errorCode.getCode() : null);
        return diagnostic;
    }
}

