/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.diagnostics;

import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.validator.IQuteErrorCode;
import com.redhat.qute.parser.validator.IQuteSyntaxValidatorReporter;
import com.redhat.qute.parser.validator.QuteSyntaxErrorCode;
import com.redhat.qute.parser.validator.QuteSyntaxValidator;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.services.diagnostics.DiagnosticDataFactory;
import com.redhat.qute.services.diagnostics.QuteErrorCode;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.UserTagSectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class QuteDiagnosticsForSyntax {
    private static final Range LEFT_TOP_RANGE = new Range(new Position(0, 0), new Position(0, 0));

    public void validateWithRealQuteParser(Template template, final List<Diagnostic> diagnostics) {
        block3: {
            EngineBuilder engineBuilder = Engine.builder().addDefaults();
            String templateContent = template.getText();
            try {
                QuteProject project = template.getProject();
                if (project != null) {
                    ArrayList<UserTag> sourceTags = new ArrayList<UserTag>(project.getSourceUserTags());
                    QuteDiagnosticsForSyntax.addUserTag(sourceTags, engineBuilder);
                    Collection binaryTags = project.getBinaryUserTags().getNow(Collections.emptyList());
                    QuteDiagnosticsForSyntax.addUserTag(binaryTags, engineBuilder);
                }
                Engine engine = engineBuilder.build();
                engine.parse(templateContent);
            }
            catch (TemplateException e) {
                if (QuteSyntaxErrorCode.isSupported(e)) break block3;
                String message = e.getMessage();
                Range range = QuteDiagnosticsForSyntax.createRange(e, template);
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, message, DiagnosticSeverity.Error, QuteErrorCode.SyntaxError);
                diagnostics.add(diagnostic);
            }
        }
        QuteSyntaxValidator syntaxValidator = new QuteSyntaxValidator(new IQuteSyntaxValidatorReporter(){

            @Override
            public void reportError(Range errorRange, Node node, IQuteErrorCode errorCode, Object ... arguments) {
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(errorRange, DiagnosticSeverity.Error, errorCode, arguments);
                diagnostics.add(diagnostic);
            }
        });
        template.accept(syntaxValidator);
    }

    private static void addUserTag(Collection<UserTag> tags, EngineBuilder engineBuilder) {
        for (UserTag userTag : tags) {
            String tagName = userTag.getName();
            String tagTemplateId = userTag.getTemplateId();
            engineBuilder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName, tagTemplateId));
        }
    }

    private static Range createRange(TemplateException e, Template template) {
        TemplateNode.Origin origin = e.getOrigin();
        if (origin == null) {
            return LEFT_TOP_RANGE;
        }
        int line = e.getOrigin().getLine() - 1;
        Position start = new Position(line, e.getOrigin().getLineCharacterStart() - 1);
        Position end = new Position(line, e.getOrigin().getLineCharacterEnd() - 1);
        return new Range(start, end);
    }
}

