/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.diagnostics;

import com.redhat.qute.ls.commons.CodeActionFactory;
import com.redhat.qute.parser.validator.IQuteErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public enum QuteErrorCode implements IQuteErrorCode
{
    ResolvingJavaType("Resolving Java type `{0}`."),
    UndefinedNamespace("No namespace resolver found for: `{0}`."),
    InvalidOperator("Invalid `{0}` operator for section `#{1}`. Allowed operators are `{2}`."),
    UndefinedObject("`{0}` cannot be resolved to an object."),
    UnknownType("`{0}` cannot be resolved to a type."),
    UnknownProperty("`{0}` cannot be resolved or is not a field of `{1}` Java type."),
    PropertyNotSupportedInNativeMode("Property `{0}` of `{1}` Java type cannot be used in native image mode."),
    InheritedPropertyNotSupportedInNativeMode("Inherited property `{0}` of `{1}` Java type cannot be used in native image mode because Java type is annotated with `@TemplateData(ignoreSuperclasses = true)`."),
    ForbiddenByRegisterForReflectionFields("The field `{0}` of `{1}` Java type cannot be used in native image mode because Java type is annotated with `@RegisterForReflection(fields = false)`."),
    PropertyIgnoredByTemplateData("The property `{0}` of `{1}` Java type cannot be used in native image mode because Java type is annotated with `@TemplateData(ignore = {2})`."),
    UnknownMethod("`{0}` cannot be resolved or is not a method of `{1}` Java type."),
    UnknownNamespaceResolverMethod("`{0}` cannot be resolved or is not a method of `{1}` namespace resolver."),
    InvalidMethodVoid("Invalid `{0}` method of `{1}` : void return is not allowed."),
    InvalidMethodFromObject("Invalid `{0}` method of `{1}` : method from `java.lang.Object` is not allowed."),
    InvalidMethodStatic("Invalid `{0}` method of `{1}` : static method is not allowed."),
    InvalidMethodParameter("The method `{0}` in the type `{1}` is not applicable for the arguments `{2}`."),
    InvalidVirtualMethod("The virtual method `{0}` in the type `{1}` is not applicable for the base object `{2}` type."),
    InfixNotationParameterRequired("A parameter for the infix notation method `{0}` is required."),
    InvalidMethodInfixNotation("The method `{0}` cannot be used with infix notation, because it does not have exactly `1` parameter."),
    MethodNotSupportedInNativeMode("Method `{0}` of `{1}` Java type cannot be used in native image mode."),
    InheritedMethodNotSupportedInNativeMode("Inherited method `{0}` of `{1}` Java type cannot be used in native image mode because Java type is annotated with `@TemplateData(ignoreSuperclasses = true)`."),
    ForbiddenByRegisterForReflectionMethods("The method `{0}` of `{1}` Java type cannot be used in native image mode because Java type is annotated with `@RegisterForReflection(methods = false)`."),
    ForbiddenByTemplateDataProperties("The method `{0}` of `{1}` Java type cannot be used in native image mode because it has `{2}` parameters and Java type is annotated with `@TemplateData(properties = true)`."),
    MethodIgnoredByTemplateData("The method `{0}` of `{1}` Java type cannot be used in native image mode because Java type is annotated with `@TemplateData(ignore = {2})`."),
    UnexpectedMemberTypeInCaseSection("Unexpected type `{0}` in `{1}`. Expected `{2}`."),
    UnexpectedValueInCaseSection("Unexpected value `{0}` in `{1}`. Expected value of type `{2}`."),
    InvalidParentInCaseSection("`{0}` section must be hosted in a #switch or #when section."),
    UnexpectedParameter("Unexpected operand `{0}`. The operator `{1}` in the `#{2}` section expects only one parameter."),
    MissingParameter("A parameter is required in the `#{0}` section."),
    IterationError("Iteration error: '{'{0}'}' resolved to [{1}] which is not iterable."),
    TemplateNotFound("Template not found: `{0}`."),
    TemplateNotDefined("Template id must be defined as parameter."),
    UndefinedSectionTag("No section helper found for `{0}`."),
    UndefinedParameter("No parameter `{0}` found for `{1}` user tag."),
    DuplicateParameter("Duplicate parameter `{0}` of `{1}` user tag."),
    MissingRequiredParameter("Missing required parameter(s) {0} of `{1}` user tag."),
    MissingExpectedInput("Missing expected input(s): {0}."),
    SyntaxError("Syntax error: `{0}`.");

    private final String rawMessage;

    private QuteErrorCode(String rawMessage) {
        this.rawMessage = rawMessage;
    }

    @Override
    public String getCode() {
        return this.name();
    }

    public String toString() {
        return this.getCode();
    }

    @Override
    public String getRawMessage() {
        return this.rawMessage;
    }

    public boolean isQuteErrorCode(Either<String, Integer> code) {
        return CodeActionFactory.isDiagnosticCode(code, this.name());
    }

    public static QuteErrorCode getErrorCode(Either<String, Integer> diagnosticCode) {
        if (diagnosticCode == null || diagnosticCode.isRight()) {
            return null;
        }
        String code = (String)diagnosticCode.getLeft();
        try {
            return QuteErrorCode.valueOf(code);
        }
        catch (Exception e) {
            return null;
        }
    }
}

