/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.inlayhint;

import com.redhat.qute.commons.QuteJavaDefinitionParams;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.CustomSection;
import com.redhat.qute.parser.template.sections.ForSection;
import com.redhat.qute.parser.template.sections.IfSection;
import com.redhat.qute.parser.template.sections.LetSection;
import com.redhat.qute.parser.template.sections.SetSection;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.datamodel.resolvers.MessageValueResolver;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.project.tags.UserTagParameter;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.ResolvingJavaTypeContext;
import com.redhat.qute.settings.QuteInlayHintSettings;
import com.redhat.qute.settings.SharedSettings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintKind;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class InlayHintASTVistor
extends ASTVisitor {
    private static final String OPEN_JAVA_TYPE_MESSAGE = "Open `{0}` Java type.";
    private static final String EDIT_JAVA_MESSAGE_MESSAGE = "Edit `{0}` Java message.";
    private static final Logger LOGGER = Logger.getLogger(InlayHintASTVistor.class.getName());
    private final int startOffset;
    private final int endOffset;
    private final QuteInlayHintSettings inlayHintSettings;
    private final ResolvingJavaTypeContext resolvingJavaTypeContext;
    private final List<InlayHint> inlayHints;
    private boolean canSupportJavaDefinition;
    private CancelChecker cancelChecker;

    public InlayHintASTVistor(int startOffset, int endOffset, SharedSettings settings, ResolvingJavaTypeContext resolvingJavaTypeContext, CancelChecker cancelChecker) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.inlayHintSettings = settings.getInlayHintSettings();
        this.resolvingJavaTypeContext = resolvingJavaTypeContext;
        this.inlayHints = new ArrayList<InlayHint>();
        this.cancelChecker = cancelChecker;
        this.canSupportJavaDefinition = settings.getCommandCapabilities().isCommandSupported("qute.command.java.definition");
    }

    public List<InlayHint> getInlayHints() {
        return this.inlayHints;
    }

    @Override
    public boolean visit(ForSection node) {
        Parameter iterableParameter;
        Parameter aliasParameter;
        this.cancelChecker.checkCanceled();
        if (!this.isAfterStartParameterVisible(node)) {
            return false;
        }
        if (this.inlayHintSettings.isShowSectionParameterType() && (aliasParameter = node.getAliasParameter()) != null && (iterableParameter = node.getIterableParameter()) != null) {
            Template template = node.getOwnerTemplate();
            QuteProject project = template.getProject();
            this.createJavaTypeInlayHint(aliasParameter, iterableParameter, template, project);
        }
        return this.isAfterEndParameterVisible(node);
    }

    @Override
    public boolean visit(IfSection node) {
        this.cancelChecker.checkCanceled();
        if (!this.isAfterStartParameterVisible(node)) {
            return false;
        }
        if (this.inlayHintSettings.isShowSectionParameterType()) {
            List<Parameter> parameters = node.getParameters();
            for (Parameter parameter : parameters) {
                if (!parameter.isOptional()) continue;
                Template template = node.getOwnerTemplate();
                QuteProject project = template.getProject();
                this.createJavaTypeInlayHint(parameter, template, project);
            }
        }
        return this.isAfterEndParameterVisible(node);
    }

    @Override
    public boolean visit(LetSection node) {
        this.cancelChecker.checkCanceled();
        if (!this.isAfterStartParameterVisible(node)) {
            return false;
        }
        this.createInlayHintParametersSection(node);
        return this.isAfterEndParameterVisible(node);
    }

    @Override
    public boolean visit(SetSection node) {
        this.cancelChecker.checkCanceled();
        if (!this.isAfterStartParameterVisible(node)) {
            return false;
        }
        this.createInlayHintParametersSection(node);
        return this.isAfterEndParameterVisible(node);
    }

    @Override
    public boolean visit(CustomSection node) {
        this.cancelChecker.checkCanceled();
        if (!this.isAfterStartParameterVisible(node)) {
            return false;
        }
        this.createInlayHintParametersSection(node);
        return this.isAfterEndParameterVisible(node);
    }

    @Override
    public boolean visit(Expression node) {
        String namespace;
        this.cancelChecker.checkCanceled();
        Part objectOrMethodPart = node.getObjectPart();
        if (objectOrMethodPart == null) {
            objectOrMethodPart = node.getMethodPart();
        }
        if (objectOrMethodPart != null && (namespace = objectOrMethodPart.getNamespace()) != null) {
            String messageContent;
            CompletableFuture<MessageValueResolver> messageFuture;
            MessageValueResolver message;
            String partName = objectOrMethodPart.getPartName();
            Template template = node.getOwnerTemplate();
            QuteProject project = template.getProject();
            if (project != null && (message = (MessageValueResolver)(messageFuture = project.findMessageValueResolver(namespace, partName)).getNow(null)) != null && (messageContent = message.getMessage()) != null) {
                try {
                    InlayHint hint = new InlayHint();
                    hint.setKind(InlayHintKind.Type);
                    if (this.canSupportJavaDefinition) {
                        InlayHintLabelPart messagePart = new InlayHintLabelPart(messageContent);
                        Command javaDefCommand = InlayHintASTVistor.createEditJavaMessageCommand(messageContent, message.getSourceType(), message.getName(), project.getUri());
                        messagePart.setCommand(javaDefCommand);
                        messagePart.setTooltip(javaDefCommand.getTitle());
                        hint.setLabel(Either.forRight(Arrays.asList(messagePart)));
                    } else {
                        hint.setLabel(Either.forLeft((Object)messageContent));
                    }
                    Position position = template.positionAt(node.getEnd());
                    hint.setPosition(position);
                    this.inlayHints.add(hint);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while creating inlay hint for message", e);
                }
            }
        }
        return super.visit(node);
    }

    private boolean isAfterStartParameterVisible(Section node) {
        if (this.startOffset == -1) {
            return true;
        }
        return node.getStart() >= this.startOffset;
    }

    private boolean isAfterEndParameterVisible(Section node) {
        if (this.endOffset == -1) {
            return true;
        }
        return node.getEndParametersOffset() < this.endOffset;
    }

    private void createInlayHintParametersSection(Section node) {
        UserTag userTag;
        boolean isShowSectionParameterType = this.inlayHintSettings.isShowSectionParameterType();
        boolean isShowSectionParameterDefaultValue = this.inlayHintSettings.isShowSectionParameterDefaultValue();
        if (!isShowSectionParameterType && !isShowSectionParameterDefaultValue) {
            return;
        }
        List<Parameter> parameters = node.getParameters();
        Template template = node.getOwnerTemplate();
        QuteProject project = template.getProject();
        List userTagParameterDefaultValues = null;
        UserTag userTag2 = userTag = isShowSectionParameterDefaultValue && project != null ? project.findUserTag(node.getTag()) : null;
        if (userTag != null) {
            userTagParameterDefaultValues = userTag.getParameters().stream().filter(p -> p.getDefaultValue() != null).map(p -> p.getName()).collect(Collectors.toList());
        }
        for (Parameter parameter : parameters) {
            if (userTagParameterDefaultValues != null) {
                userTagParameterDefaultValues.remove(parameter.getName());
            }
            if (!isShowSectionParameterType) continue;
            this.createJavaTypeInlayHint(parameter, template, project);
        }
        if (userTag != null && userTagParameterDefaultValues != null) {
            for (String name : userTagParameterDefaultValues) {
                UserTagParameter userTagParameter = userTag.findParameter(name);
                String defaultValue = userTagParameter.getDefaultValue();
                if (defaultValue == null) continue;
                this.createInlayHint(node, template, name, defaultValue);
            }
        }
    }

    private void createInlayHint(Section node, Template template, String name, String defaultValue) {
        try {
            InlayHint hint = new InlayHint();
            hint.setKind(InlayHintKind.Parameter);
            hint.setLabel(Either.forLeft((Object)(name + "=" + defaultValue)));
            int end = node.getEndParametersOffset();
            Position position = template.positionAt(end);
            hint.setPosition(position);
            this.inlayHints.add(hint);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while creating inlay hint for user tag default value parameter", e);
        }
    }

    private void createJavaTypeInlayHint(Parameter parameter, Template template, QuteProject project) {
        this.createJavaTypeInlayHint(parameter, parameter, template, project);
    }

    private void createJavaTypeInlayHint(Parameter parameter, Parameter javaTypeParameter, Template template, QuteProject project) {
        CompletableFuture<ResolvedJavaTypeInfo> javaTypeFuture = InlayHintASTVistor.getJavaType(javaTypeParameter, project);
        if (javaTypeFuture == null) {
            return;
        }
        ResolvedJavaTypeInfo javaType = javaTypeFuture.getNow(QuteCompletableFutures.RESOLVING_JAVA_TYPE);
        if (QuteCompletableFutures.isResolvingJavaType(javaType)) {
            this.resolvingJavaTypeContext.add(javaTypeFuture);
            return;
        }
        if (!parameter.isOptional() && javaType == null) {
            return;
        }
        this.createInlayHint(parameter, javaType, template);
    }

    private void createInlayHint(Parameter parameter, ResolvedJavaTypeInfo javaType, Template template) {
        try {
            InlayHint hint = new InlayHint();
            hint.setKind(InlayHintKind.Type);
            this.updateJavaType(hint, javaType, template.getProjectUri());
            int end = parameter.hasValueAssigned() ? parameter.getEndName() : parameter.getEnd();
            Position position = template.positionAt(end);
            hint.setPosition(position);
            this.inlayHints.add(hint);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while creating inlay hint for Java parameter type", e);
        }
    }

    private static CompletableFuture<ResolvedJavaTypeInfo> getJavaType(Parameter parameter, QuteProject project) {
        if (project == null) {
            return null;
        }
        Expression expression = parameter.getJavaTypeExpression();
        if (expression == null) {
            return null;
        }
        CompletableFuture<ResolvedJavaTypeInfo> javaType = null;
        String literalJavaType = expression.getLiteralJavaType();
        javaType = literalJavaType != null ? project.resolveJavaType(literalJavaType) : project.resolveJavaType(parameter);
        Section section = parameter.getOwnerSection();
        if (section.isIterable()) {
            return javaType.thenCompose(javaTypeIterable -> {
                if (javaTypeIterable == null) {
                    return CompletableFuture.completedFuture(null);
                }
                if (javaTypeIterable.isIterable()) {
                    return project.resolveJavaType(javaTypeIterable.getIterableOf());
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        return javaType;
    }

    private void updateJavaType(InlayHint hint, ResolvedJavaTypeInfo javaType, String projectUri) {
        String type = InlayHintASTVistor.getLabel(javaType);
        if (javaType != null && this.canSupportJavaDefinition) {
            InlayHintLabelPart separatorPart = new InlayHintLabelPart(":");
            InlayHintLabelPart javaTypePart = new InlayHintLabelPart(type);
            Command javaDefCommand = InlayHintASTVistor.createOpenJavaTypeCommand(javaType.getName(), projectUri);
            javaTypePart.setCommand(javaDefCommand);
            javaTypePart.setTooltip(javaDefCommand.getTitle());
            hint.setLabel(Either.forRight(Arrays.asList(separatorPart, javaTypePart)));
        } else {
            hint.setLabel(Either.forLeft((Object)(":" + type)));
        }
    }

    public static Command createOpenJavaTypeCommand(String sourceType, String projectUri) {
        String title = MessageFormat.format(OPEN_JAVA_TYPE_MESSAGE, sourceType);
        return new Command(title, "qute.command.java.definition", Arrays.asList(new QuteJavaDefinitionParams(sourceType, projectUri)));
    }

    public static Command createEditJavaMessageCommand(String messageContent, String sourceType, String sourceMethod, String projectUri) {
        String title = MessageFormat.format(EDIT_JAVA_MESSAGE_MESSAGE, messageContent);
        QuteJavaDefinitionParams params = new QuteJavaDefinitionParams(sourceType, projectUri);
        params.setSourceMethod(sourceMethod);
        return new Command(title, "qute.command.java.definition", Arrays.asList(params));
    }

    private static String getLabel(ResolvedJavaTypeInfo javaType) {
        return javaType != null ? javaType.getJavaElementSimpleType() : "?";
    }
}

