/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.nativemode;

import com.redhat.qute.commons.annotations.RegisterForReflectionAnnotation;
import com.redhat.qute.commons.annotations.TemplateDataAnnotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class JavaTypeAccessibiltyRule {
    public static final JavaTypeAccessibiltyRule ALLOWED_WITHOUT_RESTRICTION = new JavaTypeAccessibiltyRule();
    private Set<String> ignore;
    private boolean ignoreSuperClasses;
    private boolean properties;
    private List<Pattern> ignorePatterns;
    private boolean fields = true;
    private boolean methods = true;
    private boolean hasTemplateDataAnnotation;
    private boolean hasRegisterForReflectionAnnotation;

    public void merge(TemplateDataAnnotation annotation) {
        boolean properties;
        boolean ignoreSuperClasses;
        this.hasTemplateDataAnnotation = true;
        List<String> ignore = annotation.getIgnore();
        if (ignore != null && !ignore.isEmpty()) {
            if (this.ignore == null) {
                this.ignore = new HashSet<String>();
            }
            this.ignore.addAll(ignore);
        }
        if (ignoreSuperClasses = annotation.isIgnoreSuperclasses()) {
            this.ignoreSuperClasses = true;
        }
        if (properties = annotation.isProperties()) {
            this.properties = true;
        }
    }

    public void merge(RegisterForReflectionAnnotation registerForReflectionAnnotation) {
        boolean methods;
        this.hasRegisterForReflectionAnnotation = true;
        boolean fields = registerForReflectionAnnotation.isFields();
        if (!fields) {
            this.fields = false;
        }
        if (!(methods = registerForReflectionAnnotation.isMethods())) {
            this.methods = false;
        }
    }

    public String getIgnorePattern(String name) {
        if (this.ignore == null || this.ignore.isEmpty()) {
            return null;
        }
        if (this.ignorePatterns == null) {
            this.ignorePatterns = TemplateDataAnnotation.createIgnorePatterns(this.ignore);
        }
        return TemplateDataAnnotation.getMatchedIgnorePattern(name, this.ignorePatterns);
    }

    public boolean isIgnoreSuperClasses() {
        return this.ignoreSuperClasses;
    }

    public boolean isProperties() {
        return this.properties;
    }

    public boolean isFields() {
        return this.fields;
    }

    public boolean isMethods() {
        return this.methods;
    }

    public boolean hasTemplateDataAnnotation() {
        return this.hasTemplateDataAnnotation;
    }

    public boolean hasRegisterForReflectionAnnotation() {
        return this.hasRegisterForReflectionAnnotation;
    }
}

