/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.nativemode;

import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.services.nativemode.JavaTypeAccessibiltyRule;
import java.util.Set;

public interface JavaTypeFilter {
    public JavaTypeAccessibiltyRule getJavaTypeAccessibility(ResolvedJavaTypeInfo var1, Set<String> var2);

    public JavaMemberAccessibility getJavaMemberAccessibility(JavaMemberInfo var1, JavaTypeAccessibiltyRule var2);

    public boolean isSuperClassAllowed(JavaMemberInfo var1, ResolvedJavaTypeInfo var2, JavaTypeAccessibiltyRule var3);

    public boolean isIgnoreSuperclasses(ResolvedJavaTypeInfo var1, JavaTypeAccessibiltyRule var2);

    public boolean isInNativeMode();

    public static class JavaMemberAccessibility {
        public static final JavaMemberAccessibility ALLOWED = new JavaMemberAccessibility(JavaMemberAccessibilityKind.ALLOWED);
        public static final JavaMemberAccessibility FORBIDDEN_BY_TEMPLATE_DATA_PROPERTIES = new JavaMemberAccessibility(JavaMemberAccessibilityKind.FORBIDDEN_BY_TEMPLATE_DATA_PROPERTIES);
        public static final JavaMemberAccessibility FORBIDDEN_BY_REGISTER_FOR_REFLECTION_FIELDS = new JavaMemberAccessibility(JavaMemberAccessibilityKind.FORBIDDEN_BY_REGISTER_FOR_REFLECTION_FIELDS);
        public static final JavaMemberAccessibility FORBIDDEN_BY_REGISTER_FOR_REFLECTION_METHODS = new JavaMemberAccessibility(JavaMemberAccessibilityKind.FORBIDDEN_BY_REGISTER_FOR_REFLECTION_METHODS);
        private final JavaMemberAccessibilityKind kind;
        private final String ignore;

        public JavaMemberAccessibility(JavaMemberAccessibilityKind kind) {
            this(kind, null);
        }

        public JavaMemberAccessibility(JavaMemberAccessibilityKind kind, String ignore) {
            this.kind = kind;
            this.ignore = ignore;
        }

        public JavaMemberAccessibilityKind getKind() {
            return this.kind;
        }

        public String getIgnore() {
            return this.ignore;
        }

        public static JavaMemberAccessibility createIgnoreAccess(String ignore) {
            return new JavaMemberAccessibility(JavaMemberAccessibilityKind.FORBIDDEN_BY_TEMPLATE_DATA_IGNORE, ignore);
        }
    }

    public static enum JavaMemberAccessibilityKind {
        ALLOWED,
        FORBIDDEN_BY_TEMPLATE_DATA_IGNORE,
        FORBIDDEN_BY_TEMPLATE_DATA_PROPERTIES,
        FORBIDDEN_BY_REGISTER_FOR_REFLECTION_FIELDS,
        FORBIDDEN_BY_REGISTER_FOR_REFLECTION_METHODS;

    }
}

