/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.nativemode;

import com.redhat.qute.commons.JavaElementKind;
import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.annotations.TemplateDataAnnotation;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.services.nativemode.JavaTypeAccessibiltyRule;
import com.redhat.qute.services.nativemode.JavaTypeFilter;
import java.util.List;
import java.util.Set;

public class NativeModeJavaTypeFilter
implements JavaTypeFilter {
    private final QuteProject project;

    public NativeModeJavaTypeFilter(QuteProject project) {
        this.project = project;
    }

    @Override
    public JavaTypeAccessibiltyRule getJavaTypeAccessibility(ResolvedJavaTypeInfo javaType, Set<String> templateParameterDeclarationJavaTypes) {
        if (templateParameterDeclarationJavaTypes.contains(javaType.getName())) {
            return JavaTypeAccessibiltyRule.ALLOWED_WITHOUT_RESTRICTION;
        }
        return this.project.getJavaTypeAccessibiltyInNativeMode(javaType.getName());
    }

    @Override
    public JavaTypeFilter.JavaMemberAccessibility getJavaMemberAccessibility(JavaMemberInfo member, JavaTypeAccessibiltyRule rule) {
        JavaTypeFilter.JavaMemberAccessibility templateDataAccessibility = NativeModeJavaTypeFilter.getJavaMemberAccessibilityForTemplateData(member, rule);
        if (templateDataAccessibility == JavaTypeFilter.JavaMemberAccessibility.ALLOWED) {
            return JavaTypeFilter.JavaMemberAccessibility.ALLOWED;
        }
        JavaTypeFilter.JavaMemberAccessibility registerForReflectionAccessibility = NativeModeJavaTypeFilter.getJavaMemberAccessibilityForRegisterForReflection(member, rule);
        if (registerForReflectionAccessibility == JavaTypeFilter.JavaMemberAccessibility.ALLOWED) {
            return JavaTypeFilter.JavaMemberAccessibility.ALLOWED;
        }
        if (templateDataAccessibility == null) {
            if (registerForReflectionAccessibility == null) {
                return JavaTypeFilter.JavaMemberAccessibility.ALLOWED;
            }
            return registerForReflectionAccessibility;
        }
        return templateDataAccessibility;
    }

    private static JavaTypeFilter.JavaMemberAccessibility getJavaMemberAccessibilityForTemplateData(JavaMemberInfo member, JavaTypeAccessibiltyRule rule) {
        String pattern = rule.getIgnorePattern(member.getName());
        if (pattern != null) {
            return JavaTypeFilter.JavaMemberAccessibility.createIgnoreAccess(pattern);
        }
        if (rule.isProperties() && !NativeModeJavaTypeFilter.isProperty(member)) {
            return JavaTypeFilter.JavaMemberAccessibility.FORBIDDEN_BY_TEMPLATE_DATA_PROPERTIES;
        }
        if (rule.hasTemplateDataAnnotation()) {
            return JavaTypeFilter.JavaMemberAccessibility.ALLOWED;
        }
        return null;
    }

    private static boolean isProperty(JavaMemberInfo member) {
        switch (member.getJavaElementKind()) {
            case FIELD: {
                return true;
            }
            case METHOD: {
                return ((JavaMethodInfo)member).getParameters().isEmpty();
            }
        }
        return false;
    }

    private static JavaTypeFilter.JavaMemberAccessibility getJavaMemberAccessibilityForRegisterForReflection(JavaMemberInfo member, JavaTypeAccessibiltyRule rule) {
        if (!rule.isFields() && member.getJavaElementKind() == JavaElementKind.FIELD) {
            return JavaTypeFilter.JavaMemberAccessibility.FORBIDDEN_BY_REGISTER_FOR_REFLECTION_FIELDS;
        }
        if (!rule.isMethods() && member.getJavaElementKind() == JavaElementKind.METHOD) {
            return JavaTypeFilter.JavaMemberAccessibility.FORBIDDEN_BY_REGISTER_FOR_REFLECTION_METHODS;
        }
        if (rule.hasRegisterForReflectionAnnotation()) {
            return JavaTypeFilter.JavaMemberAccessibility.ALLOWED;
        }
        return null;
    }

    @Override
    public boolean isIgnoreSuperclasses(ResolvedJavaTypeInfo baseType, JavaTypeAccessibiltyRule rule) {
        if (this.isIgnoreSuperclasses(baseType)) {
            return true;
        }
        return rule.isIgnoreSuperClasses();
    }

    private boolean isIgnoreSuperclasses(ResolvedJavaTypeInfo targetType) {
        List<TemplateDataAnnotation> annotations = targetType.getTemplateDataAnnotations();
        return annotations != null && annotations.stream().anyMatch(TemplateDataAnnotation::isIgnoreSuperclasses);
    }

    @Override
    public boolean isSuperClassAllowed(JavaMemberInfo member, ResolvedJavaTypeInfo baseType, JavaTypeAccessibiltyRule rule) {
        ResolvedJavaTypeInfo memberType = (ResolvedJavaTypeInfo)member.getJavaTypeInfo();
        if (memberType.equals(baseType)) {
            return true;
        }
        return !this.isIgnoreSuperclasses(memberType, rule);
    }

    @Override
    public boolean isInNativeMode() {
        return true;
    }
}

