/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services.snippets;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.services.completions.CompletionRequest;
import com.redhat.qute.services.snippets.AbstractQuteSnippetContext;
import java.io.IOException;
import java.util.Map;

public class QuteParentSnippetContext
extends AbstractQuteSnippetContext {
    public static final TypeAdapter<QuteParentSnippetContext> IN_PARENT = new SnippetContextForQuteParentAdapter();
    private final String parent;
    private final boolean unique;

    public QuteParentSnippetContext(String parent, boolean unique) {
        this.parent = parent;
        this.unique = unique;
    }

    @Override
    public boolean isMatch(CompletionRequest request, Map<String, String> model) {
        Node node = request.getNode();
        if (this.isMatchParent(node) && this.isMatchUnique(node)) {
            if (node.getKind() == NodeKind.Template || node.getKind() == NodeKind.Text) {
                return true;
            }
            if (node.getKind() == NodeKind.Section) {
                Section section = (Section)node;
                return section.isInStartTagName(request.getOffset());
            }
        }
        return false;
    }

    private boolean isMatchParent(Node node) {
        return node.getParentSection() != null && this.parent.equals(node.getParentSection().getTag());
    }

    private boolean isMatchUnique(Node node) {
        if (!this.unique) {
            return true;
        }
        Section parentSection = node.getParentSection();
        if (parentSection != null) {
            for (Node child : parentSection.getChildren()) {
                if (!(child instanceof Section) || ((Section)child).getTag() == null || !((Section)child).getTag().equals(this.getTag())) continue;
                return false;
            }
        }
        return true;
    }

    private String getTag() {
        return super.getPrefixes().get(0);
    }

    private static class SnippetContextForQuteParentAdapter
    extends TypeAdapter<QuteParentSnippetContext> {
        private SnippetContextForQuteParentAdapter() {
        }

        public QuteParentSnippetContext read(JsonReader in) throws IOException {
            JsonToken nextToken = in.peek();
            if (nextToken == JsonToken.NULL) {
                return null;
            }
            String parent = null;
            boolean unique = false;
            in.beginObject();
            block8: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "parent": {
                        if (in.peek() != JsonToken.STRING) continue block8;
                        parent = in.nextString();
                        continue block8;
                    }
                    case "unique": {
                        if (in.peek() != JsonToken.BOOLEAN) continue block8;
                        unique = in.nextBoolean();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            if (parent != null) {
                return new QuteParentSnippetContext(parent, unique);
            }
            return null;
        }

        public void write(JsonWriter out, QuteParentSnippetContext value) throws IOException {
        }
    }
}

