/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.settings;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.logging.Logger;

public class FaultTolerantTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Logger LOGGER = Logger.getLogger(FaultTolerantTypeAdapterFactory.class.getName());

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        return this.wrapTypeAdapter(gson.getDelegateAdapter((TypeAdapterFactory)this, type));
    }

    private <T> TypeAdapter<T> wrapTypeAdapter(final TypeAdapter<T> typeAdapter) {
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                typeAdapter.write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                try {
                    return typeAdapter.read(in);
                }
                catch (Exception e) {
                    LOGGER.warning("Encountered an invalid setting. Using the default value. Please check your settings for outdated or invalid settings.\n" + e);
                    in.skipValue();
                    return null;
                }
            }
        };
    }
}

