/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.settings;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathPatternMatcher {
    private static final boolean isWindows;
    private static final Logger LOGGER;
    private transient PathMatcher pathMatcher;
    private final String pattern;

    public PathPatternMatcher(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean matches(URI templateUri) {
        if (this.pattern == null || this.pattern.length() < 1) {
            return false;
        }
        try {
            return this.getPathMatcher().matches(Path.of(templateUri));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while matching uri '" + templateUri.toString() + "' with pattern '" + this.pattern + "'.", e);
            return false;
        }
    }

    private PathMatcher getPathMatcher() {
        if (this.pathMatcher != null) {
            return this.pathMatcher;
        }
        this.pathMatcher = this.createPathMatcher();
        return this.pathMatcher;
    }

    private synchronized PathMatcher createPathMatcher() {
        if (this.pathMatcher != null) {
            return this.pathMatcher;
        }
        String glob = PathPatternMatcher.getGlobPattern(this.pattern);
        return FileSystems.getDefault().getPathMatcher("glob:" + glob);
    }

    private static String getGlobPattern(String pattern) {
        boolean schemaFile = pattern.startsWith("file:");
        if (schemaFile) {
            String convertedUri = pattern.replace("file:///", "file:/");
            convertedUri = convertedUri.replace("file://", "file:/");
            convertedUri = isWindows ? convertedUri.replace("file:/", "") : convertedUri.replace("file:", "");
            try {
                convertedUri = URLDecoder.decode(convertedUri, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.log(Level.SEVERE, "Error while decoding uri '" + pattern + "'.", e);
            }
            return convertedUri;
        }
        char c = pattern.charAt(0);
        if (c != '*' && c != '?' && c != '/') {
            return "**/" + pattern;
        }
        return pattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathPatternMatcher other = (PathPatternMatcher)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }

    static {
        String osName = System.getProperty("os.name");
        isWindows = osName != null && osName.toLowerCase().contains("win");
        LOGGER = Logger.getLogger(PathPatternMatcher.class.getName());
    }
}

