/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.settings;

import com.google.gson.annotations.SerializedName;
import com.redhat.qute.settings.BaseSettings;
import com.redhat.qute.settings.QuteCodeLensSettings;
import com.redhat.qute.settings.QuteInlayHintSettings;
import com.redhat.qute.settings.QuteNativeSettings;
import com.redhat.qute.settings.QuteValidationSettings;
import com.redhat.qute.settings.SharedSettings;
import com.redhat.qute.utils.JSONUtility;
import java.util.Map;

public class QuteGeneralClientSettings {
    private Map<String, QuteGeneralClientSettings> workspaceFolders;
    private QuteCodeLensSettings codeLens;
    private QuteInlayHintSettings inlayHint;
    private QuteValidationSettings validation;
    @SerializedName(value="native")
    private QuteNativeSettings nativeImages;

    public QuteCodeLensSettings getCodeLens() {
        return this.codeLens;
    }

    public QuteInlayHintSettings getInlayHint() {
        return this.inlayHint;
    }

    public QuteValidationSettings getValidation() {
        return this.validation;
    }

    public QuteNativeSettings getNativeImages() {
        return this.nativeImages;
    }

    public void setCodeLens(QuteCodeLensSettings codeLens) {
        this.codeLens = codeLens;
    }

    public void setInlayHint(QuteInlayHintSettings inlayHint) {
        this.inlayHint = inlayHint;
    }

    public void setValidation(QuteValidationSettings validation) {
        this.validation = validation;
    }

    public void setNativeImages(QuteNativeSettings nativeImages) {
        this.nativeImages = nativeImages;
    }

    public Map<String, QuteGeneralClientSettings> getWorkspaceFolders() {
        return this.workspaceFolders;
    }

    public void setWorkspaceFolders(Map<String, QuteGeneralClientSettings> workspaceFolders) {
        this.workspaceFolders = workspaceFolders;
    }

    public static QuteGeneralClientSettings getGeneralQuteSettings(Object initializationOptionsSettings) {
        return JSONUtility.toModel(initializationOptionsSettings, QuteGeneralClientSettings.class);
    }

    public static SettingsUpdateState update(SharedSettings sharedSettings, QuteGeneralClientSettings clientSettings) {
        Map<String, QuteGeneralClientSettings> workspaceFolders = clientSettings.getWorkspaceFolders();
        boolean workspaceChanged = sharedSettings.cleanWorkspaceFolderSettings(workspaceFolders != null ? workspaceFolders.keySet() : null);
        boolean codeLensSettingsChanged = QuteGeneralClientSettings.updateCodeLensSettings(sharedSettings, clientSettings);
        if (workspaceChanged) {
            codeLensSettingsChanged = true;
        }
        boolean inlayHintSettingsChanged = QuteGeneralClientSettings.updateInlayHintSettings(sharedSettings, clientSettings);
        if (workspaceChanged) {
            inlayHintSettingsChanged = true;
        }
        boolean validationSettingsChanged = QuteGeneralClientSettings.updateValidationSettings(sharedSettings, clientSettings);
        if (workspaceChanged) {
            validationSettingsChanged = true;
        }
        boolean nativeImagesSettingsChanged = QuteGeneralClientSettings.updateNativeImagesSettings(sharedSettings, clientSettings);
        if (workspaceChanged) {
            nativeImagesSettingsChanged = true;
        }
        return new SettingsUpdateState(validationSettingsChanged, codeLensSettingsChanged, inlayHintSettingsChanged, nativeImagesSettingsChanged);
    }

    private static boolean updateCodeLensSettings(SharedSettings sharedSettings, QuteGeneralClientSettings clientSettings) {
        boolean codeLensSettingsChanged = QuteGeneralClientSettings.updateCodeLensSettings((BaseSettings)sharedSettings, clientSettings.getCodeLens());
        Map<String, QuteGeneralClientSettings> workspaceFolders = clientSettings.getWorkspaceFolders();
        if (workspaceFolders != null) {
            for (Map.Entry<String, QuteGeneralClientSettings> entry : workspaceFolders.entrySet()) {
                String workspaceFolderUri = entry.getKey();
                BaseSettings settings = sharedSettings.getWorkspaceFolderSettings(workspaceFolderUri);
                codeLensSettingsChanged |= QuteGeneralClientSettings.updateCodeLensSettings(settings, entry.getValue().getCodeLens());
            }
        }
        return codeLensSettingsChanged;
    }

    private static boolean updateCodeLensSettings(BaseSettings sharedSettings, QuteCodeLensSettings codeLens) {
        if (codeLens != null && !codeLens.equals(sharedSettings.getCodeLensSettings())) {
            sharedSettings.getCodeLensSettings().update(codeLens);
            return true;
        }
        return false;
    }

    private static boolean updateInlayHintSettings(SharedSettings sharedSettings, QuteGeneralClientSettings clientSettings) {
        boolean inlayHintSettingsChanged = QuteGeneralClientSettings.updateInlayHintSettings((BaseSettings)sharedSettings, clientSettings.getInlayHint());
        Map<String, QuteGeneralClientSettings> workspaceFolders = clientSettings.getWorkspaceFolders();
        if (workspaceFolders != null) {
            for (Map.Entry<String, QuteGeneralClientSettings> entry : workspaceFolders.entrySet()) {
                String workspaceFolderUri = entry.getKey();
                BaseSettings settings = sharedSettings.getWorkspaceFolderSettings(workspaceFolderUri);
                inlayHintSettingsChanged |= QuteGeneralClientSettings.updateInlayHintSettings(settings, entry.getValue().getInlayHint());
            }
        }
        return inlayHintSettingsChanged;
    }

    private static boolean updateInlayHintSettings(BaseSettings sharedSettings, QuteInlayHintSettings inlayHint) {
        if (inlayHint != null && !inlayHint.equals(sharedSettings.getInlayHintSettings())) {
            sharedSettings.getInlayHintSettings().update(inlayHint);
            return true;
        }
        return false;
    }

    private static boolean updateValidationSettings(SharedSettings sharedSettings, QuteGeneralClientSettings clientSettings) {
        boolean validationSettingsChanged = QuteGeneralClientSettings.updateValidationSettings((BaseSettings)sharedSettings, clientSettings.getValidation());
        Map<String, QuteGeneralClientSettings> workspaceFolders = clientSettings.getWorkspaceFolders();
        if (workspaceFolders != null) {
            for (Map.Entry<String, QuteGeneralClientSettings> entry : workspaceFolders.entrySet()) {
                String workspaceFolderUri = entry.getKey();
                BaseSettings settings = sharedSettings.getWorkspaceFolderSettings(workspaceFolderUri);
                validationSettingsChanged |= QuteGeneralClientSettings.updateValidationSettings(settings, entry.getValue().getValidation());
            }
        }
        return validationSettingsChanged;
    }

    private static boolean updateValidationSettings(BaseSettings sharedSettings, QuteValidationSettings validation) {
        if (validation != null && !validation.equals(sharedSettings.getValidationSettings())) {
            sharedSettings.getValidationSettings().update(validation);
            return true;
        }
        return false;
    }

    private static boolean updateNativeImagesSettings(SharedSettings sharedSettings, QuteGeneralClientSettings clientSettings) {
        boolean nativeImagesSettingsChanged = QuteGeneralClientSettings.updateNativeImagesSettings((BaseSettings)sharedSettings, clientSettings.getNativeImages());
        Map<String, QuteGeneralClientSettings> workspaceFolders = clientSettings.getWorkspaceFolders();
        if (workspaceFolders != null) {
            for (Map.Entry<String, QuteGeneralClientSettings> entry : workspaceFolders.entrySet()) {
                String workspaceFolderUri = entry.getKey();
                BaseSettings settings = sharedSettings.getWorkspaceFolderSettings(workspaceFolderUri);
                nativeImagesSettingsChanged |= QuteGeneralClientSettings.updateNativeImagesSettings(settings, entry.getValue().getNativeImages());
            }
        }
        return nativeImagesSettingsChanged;
    }

    private static boolean updateNativeImagesSettings(BaseSettings sharedSettings, QuteNativeSettings nativeImages) {
        if (nativeImages != null && !nativeImages.equals(sharedSettings.getNativeSettings())) {
            sharedSettings.getNativeSettings().update(nativeImages);
            return true;
        }
        return false;
    }

    public static class SettingsUpdateState {
        private final boolean validationSettingsChanged;
        private final boolean codeLensSettingsChanged;
        private final boolean inlayHintSettingsChanged;
        private boolean nativeImagesSettingsChanged;

        public SettingsUpdateState(boolean validationSettingsChanged, boolean codeLensSettingsChanged, boolean inlayHintSettingsChanged, boolean nativeImagesSettingsChanged) {
            this.validationSettingsChanged = validationSettingsChanged;
            this.codeLensSettingsChanged = codeLensSettingsChanged;
            this.inlayHintSettingsChanged = inlayHintSettingsChanged;
            this.nativeImagesSettingsChanged = nativeImagesSettingsChanged;
        }

        public boolean isValidationSettingsChanged() {
            return this.validationSettingsChanged;
        }

        public boolean isCodeLensSettingsChanged() {
            return this.codeLensSettingsChanged;
        }

        public boolean isInlayHintSettingsChanged() {
            return this.inlayHintSettingsChanged;
        }

        public boolean isNativeImagesSettingsChanged() {
            return this.nativeImagesSettingsChanged;
        }
    }
}

