/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.settings;

import com.redhat.qute.settings.PathPatternMatcher;
import com.redhat.qute.settings.QuteValidationTypeSettings;
import com.redhat.qute.utils.FileUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class QuteValidationSettings {
    public static final QuteValidationSettings DEFAULT;
    private static final QuteValidationTypeSettings DEFAULT_UNDEFINED_OBJECT;
    private static final QuteValidationTypeSettings DEFAULT_UNDEFINED_NAMESPACE;
    private boolean enabled;
    private QuteValidationTypeSettings undefinedObject;
    private QuteValidationTypeSettings undefinedNamespace;
    private List<String> excluded;
    private transient boolean updated;
    private transient List<PathPatternMatcher> excludedPatterns;

    public QuteValidationSettings() {
        this.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getExcluded() {
        return this.excluded;
    }

    public void setExcluded(List<String> excluded) {
        this.excluded = excluded;
        this.excludedPatterns = null;
    }

    private void updateDefault() {
        if (this.updated) {
            return;
        }
        this.setUndefinedObject(this.undefinedObject != null ? this.undefinedObject : DEFAULT_UNDEFINED_OBJECT);
        this.setUndefinedNamespace(this.undefinedNamespace != null ? this.undefinedNamespace : DEFAULT_UNDEFINED_NAMESPACE);
        this.updated = true;
    }

    public void update(QuteValidationSettings newValidation) {
        this.setEnabled(newValidation.isEnabled());
        this.setExcluded(newValidation.getExcluded());
        this.setUndefinedObject(newValidation.getUndefinedObject());
        this.setUndefinedNamespace(newValidation.getUndefinedNamespace());
    }

    public QuteValidationTypeSettings getUndefinedObject() {
        this.updateDefault();
        return this.undefinedObject;
    }

    public void setUndefinedObject(QuteValidationTypeSettings undefinedObject) {
        this.undefinedObject = undefinedObject;
        this.updated = false;
    }

    public QuteValidationTypeSettings getUndefinedNamespace() {
        this.updateDefault();
        return this.undefinedNamespace;
    }

    public void setUndefinedNamespace(QuteValidationTypeSettings undefinedNamespace) {
        this.undefinedNamespace = undefinedNamespace;
        this.updated = false;
    }

    public boolean canValidate(String templateUri) {
        if (!this.isEnabled()) {
            return false;
        }
        return !this.isExcluded(templateUri);
    }

    private boolean isExcluded(String templateUri) {
        if (this.excluded == null) {
            return false;
        }
        URI uri = URI.create(templateUri);
        if (!FileUtils.isFileURI(uri)) {
            return false;
        }
        for (PathPatternMatcher matcher : this.getExcludedPatterns()) {
            if (!matcher.matches(uri)) continue;
            return true;
        }
        return false;
    }

    public List<PathPatternMatcher> getExcludedPatterns() {
        if (this.excludedPatterns == null) {
            this.excludedPatterns = this.createExcluded(this.excluded);
        }
        return this.excludedPatterns;
    }

    public List<String> getMatchingExcluded(String templateUri) {
        if (this.excluded == null) {
            return Collections.emptyList();
        }
        URI uri = URI.create(templateUri);
        if (!FileUtils.isFileURI(uri)) {
            return Collections.emptyList();
        }
        ArrayList<String> matching = new ArrayList<String>();
        for (PathPatternMatcher matcher : this.getExcludedPatterns()) {
            if (!matcher.matches(uri)) continue;
            matching.add(matcher.getPattern());
        }
        return matching;
    }

    private List<PathPatternMatcher> createExcluded(List<String> excluded) {
        if (excluded == null || excluded.isEmpty()) {
            return Collections.emptyList();
        }
        return excluded.stream().map(pattern -> new PathPatternMatcher((String)pattern)).collect(Collectors.toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.excluded == null ? 0 : this.excluded.hashCode());
        result = 31 * result + (this.undefinedObject == null ? 0 : this.undefinedObject.hashCode());
        result = 31 * result + (this.undefinedNamespace == null ? 0 : this.undefinedNamespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuteValidationSettings other = (QuteValidationSettings)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.excluded == null ? other.excluded != null : !this.excluded.equals(other.excluded)) {
            return false;
        }
        if (this.undefinedObject == null ? !this.getUndefinedObject().equals(other.getUndefinedObject()) : !this.undefinedObject.equals(other.undefinedObject)) {
            return false;
        }
        return !(this.undefinedNamespace == null ? !this.getUndefinedNamespace().equals(other.getUndefinedNamespace()) : !this.undefinedNamespace.equals(other.undefinedNamespace));
    }

    static {
        DEFAULT_UNDEFINED_OBJECT = new QuteValidationTypeSettings();
        DEFAULT_UNDEFINED_OBJECT.setSeverity(Severity.warning.name());
        DEFAULT_UNDEFINED_NAMESPACE = new QuteValidationTypeSettings();
        DEFAULT_UNDEFINED_NAMESPACE.setSeverity(Severity.warning.name());
        DEFAULT = new QuteValidationSettings();
        DEFAULT.updateDefault();
    }

    public static enum Severity {
        ignore,
        error,
        warning;

    }
}

