/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.settings;

import com.redhat.qute.settings.BaseSettings;
import com.redhat.qute.settings.QuteCodeActionSettings;
import com.redhat.qute.settings.QuteCommandCapabilities;
import com.redhat.qute.settings.QuteCompletionSettings;
import com.redhat.qute.settings.QuteFormattingSettings;
import com.redhat.qute.settings.QuteHoverSettings;
import com.redhat.qute.settings.QuteValidationSettings;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SharedSettings
extends BaseSettings {
    private final QuteCompletionSettings completionSettings = new QuteCompletionSettings();
    private final QuteFormattingSettings formattingSettings = new QuteFormattingSettings();
    private final QuteHoverSettings hoverSettings = new QuteHoverSettings();
    private final QuteCommandCapabilities commandCapabilities = new QuteCommandCapabilities();
    private final QuteCodeActionSettings codeActionSettings = new QuteCodeActionSettings();
    private Map<String, BaseSettings> workspaceFolders;

    public QuteCompletionSettings getCompletionSettings() {
        return this.completionSettings;
    }

    public QuteFormattingSettings getFormattingSettings() {
        return this.formattingSettings;
    }

    public QuteValidationSettings getValidationSettings(String templateFileUri) {
        return this.getSettings(templateFileUri).getValidationSettings();
    }

    public QuteHoverSettings getHoverSettings() {
        return this.hoverSettings;
    }

    public QuteCommandCapabilities getCommandCapabilities() {
        return this.commandCapabilities;
    }

    public QuteCodeActionSettings getCodeActionSettings() {
        return this.codeActionSettings;
    }

    private BaseSettings getSettings(String templateFileUri) {
        if (this.workspaceFolders != null) {
            for (Map.Entry<String, BaseSettings> entry : this.workspaceFolders.entrySet()) {
                String workspaceFolderUri = entry.getKey();
                if (!templateFileUri.startsWith(workspaceFolderUri)) continue;
                return entry.getValue();
            }
        }
        return this;
    }

    public BaseSettings getWorkspaceFolderSettings(String workspaceFolderUri) {
        if (this.workspaceFolders == null) {
            this.workspaceFolders = new HashMap<String, BaseSettings>();
        }
        if (!this.workspaceFolders.containsKey(workspaceFolderUri)) {
            this.workspaceFolders.put(workspaceFolderUri, new BaseSettings());
        }
        return this.workspaceFolders.get(workspaceFolderUri);
    }

    public boolean cleanWorkspaceFolderSettings(Set<String> existingWorkspaceFolderUris) {
        if (this.workspaceFolders == null) {
            return false;
        }
        if (existingWorkspaceFolderUris == null) {
            this.workspaceFolders.clear();
            return true;
        }
        boolean changed = false;
        HashSet<String> uris = new HashSet<String>(this.getWorkspaceFolderSettingsUris());
        for (String uri : uris) {
            if (existingWorkspaceFolderUris.contains(uri)) continue;
            this.workspaceFolders.remove(uri);
            changed = true;
        }
        return changed;
    }

    public Set<String> getWorkspaceFolderSettingsUris() {
        if (this.workspaceFolders == null) {
            return Collections.emptySet();
        }
        return this.workspaceFolders.keySet();
    }
}

