/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.settings.capabilities;

import com.redhat.qute.ls.commons.client.ExtendedClientCapabilities;
import com.redhat.qute.settings.capabilities.ClientCapabilitiesWrapper;
import com.redhat.qute.settings.capabilities.ServerCapabilitiesConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;

public class QuteCapabilityManager {
    private final Set<String> registeredCapabilities = new HashSet<String>(3);
    private final LanguageClient languageClient;
    private ClientCapabilitiesWrapper clientWrapper;

    public QuteCapabilityManager(LanguageClient languageClient) {
        this.languageClient = languageClient;
    }

    public void initializeCapabilities() {
        if (this.getClientCapabilities().isCodeActionDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.CODE_ACTION_ID, "textDocument/codeAction", ServerCapabilitiesConstants.DEFAULT_CODE_ACTION_OPTIONS);
        }
        if (this.getClientCapabilities().isCodeLensDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.CODE_LENS_ID, "textDocument/codeLens", ServerCapabilitiesConstants.DEFAULT_CODELENS_OPTIONS);
        }
        if (this.getClientCapabilities().isCompletionDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.COMPLETION_ID, "textDocument/completion", ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS);
        }
        if (this.getClientCapabilities().isDefinitionDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.DOCUMENT_DEFINITION_ID, "textDocument/definition");
        }
        if (this.getClientCapabilities().isDocumentLinkDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.DOCUMENT_DEFINITION_ID, "textDocument/definition");
        }
        if (this.getClientCapabilities().isDocumentHighlightDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.DOCUMENT_HIGHLIGHT_ID, "textDocument/documentHighlight");
        }
        if (this.getClientCapabilities().isDocumentLinkDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.DOCUMENT_LINK_ID, "textDocument/documentLink", ServerCapabilitiesConstants.DEFAULT_DOCUMENT_LINK_OPTIONS);
        }
        if (this.getClientCapabilities().isDocumentSymbolDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.DOCUMENT_SYMBOL_ID, "textDocument/documentSymbol");
        }
        if (this.getClientCapabilities().isHoverDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.HOVER_ID, "textDocument/hover");
        }
        if (this.getClientCapabilities().isLinkedEditingRangeDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.LINKED_EDITING_RANGE_ID, "textDocument/linkedEditingRange");
        }
        if (this.getClientCapabilities().isReferencesDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.REFERENCES_ID, "textDocument/references");
        }
        if (this.getClientCapabilities().isRenameDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.RENAME_ID, "textDocument/rename");
        }
        if (this.getClientCapabilities().isInlayHintDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.INLAY_HINT_ID, "textDocument/inlayHint");
        }
        if (this.getClientCapabilities().isDidChangeWatchedFilesRegistered()) {
            this.registerWatchedFiles();
        }
    }

    private void registerWatchedFiles() {
        ArrayList<FileSystemWatcher> watchers = new ArrayList<FileSystemWatcher>(5);
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"**/*.html")));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"**/*.json")));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"**/*.yaml")));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"**/*.yml")));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"**/*.txt")));
        DidChangeWatchedFilesRegistrationOptions options = new DidChangeWatchedFilesRegistrationOptions(watchers);
        this.registerCapability(ServerCapabilitiesConstants.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles", options);
    }

    public void setClientCapabilities(ClientCapabilities clientCapabilities, ExtendedClientCapabilities extendedClientCapabilities) {
        this.clientWrapper = new ClientCapabilitiesWrapper(clientCapabilities, extendedClientCapabilities);
    }

    public ClientCapabilitiesWrapper getClientCapabilities() {
        if (this.clientWrapper == null) {
            this.clientWrapper = new ClientCapabilitiesWrapper();
        }
        return this.clientWrapper;
    }

    public Set<String> getRegisteredCapabilities() {
        return this.registeredCapabilities;
    }

    private void registerCapability(String id, String method) {
        this.registerCapability(id, method, null);
    }

    private void registerCapability(String id, String method, Object options) {
        if (this.registeredCapabilities.add(id)) {
            Registration registration = new Registration(id, method, options);
            RegistrationParams registrationParams = new RegistrationParams(Collections.singletonList(registration));
            this.languageClient.registerCapability(registrationParams);
        }
    }

    public void registerExecuteCommand(List<String> commands) {
        this.registerCapability(ServerCapabilitiesConstants.WORKSPACE_EXECUTE_COMMAND_ID, "workspace/executeCommand", new ExecuteCommandOptions(commands));
    }
}

