/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.settings.capabilities;

import com.redhat.qute.settings.capabilities.ClientCapabilitiesWrapper;
import com.redhat.qute.settings.capabilities.ServerCapabilitiesConstants;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;

public class ServerCapabilitiesInitializer {
    private ServerCapabilitiesInitializer() {
    }

    public static ServerCapabilities getNonDynamicServerCapabilities(ClientCapabilitiesWrapper clientCapabilities) {
        ServerCapabilities serverCapabilities = new ServerCapabilities();
        serverCapabilities.setTextDocumentSync(TextDocumentSyncKind.Incremental);
        serverCapabilities.setDocumentHighlightProvider(Boolean.valueOf(!clientCapabilities.isDocumentHighlightDynamicRegistered()));
        serverCapabilities.setDefinitionProvider(Boolean.valueOf(!clientCapabilities.isDefinitionDynamicRegistered()));
        if (!clientCapabilities.isDocumentLinkDynamicRegistered()) {
            serverCapabilities.setDocumentLinkProvider(ServerCapabilitiesConstants.DEFAULT_DOCUMENT_LINK_OPTIONS);
        }
        serverCapabilities.setDocumentSymbolProvider(Boolean.valueOf(!clientCapabilities.isDocumentSymbolDynamicRegistrationSupported()));
        serverCapabilities.setHoverProvider(Boolean.valueOf(!clientCapabilities.isHoverDynamicRegistered()));
        if (!clientCapabilities.isCodeActionDynamicRegistered()) {
            serverCapabilities.setCodeActionProvider(ServerCapabilitiesConstants.DEFAULT_CODE_ACTION_OPTIONS);
        }
        if (!clientCapabilities.isCompletionDynamicRegistrationSupported()) {
            serverCapabilities.setCompletionProvider(ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS);
        }
        if (!clientCapabilities.isCodeLensDynamicRegistered()) {
            serverCapabilities.setCodeLensProvider(ServerCapabilitiesConstants.DEFAULT_CODELENS_OPTIONS);
        }
        serverCapabilities.setReferencesProvider(Boolean.valueOf(!clientCapabilities.isReferencesDynamicRegistrationSupported()));
        serverCapabilities.setLinkedEditingRangeProvider(Boolean.valueOf(!clientCapabilities.isLinkedEditingRangeDynamicRegistered()));
        serverCapabilities.setInlayHintProvider(Boolean.valueOf(!clientCapabilities.isInlayHintDynamicRegistered()));
        serverCapabilities.setRenameProvider(Boolean.valueOf(!clientCapabilities.isRenameDynamicRegistered()));
        return serverCapabilities;
    }
}

