/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.utils;

import com.redhat.qute.utils.StringUtils;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;

public class FileUtils {
    private static final String FILE_SCHEME = "file";

    public static boolean isFileURI(URI uri) {
        return StringUtils.isEmpty(uri.getScheme()) || FILE_SCHEME.equals(uri.getScheme());
    }

    public static Path createPath(String uriString) {
        if (StringUtils.isEmpty(uriString)) {
            return null;
        }
        try {
            URI uri = URI.create(uriString);
            if (!FileUtils.isFileURI(uri)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        String fileUri = uriString;
        if (fileUri.startsWith("file:/")) {
            String convertedUri = fileUri.replace("file:///", "file:/");
            convertedUri = convertedUri.replace("file://", "file:/");
            return new File(URI.create(convertedUri)).toPath();
        }
        return new File(fileUri).toPath();
    }

    public static String toUri(Path path) {
        return path.toUri().toASCIIString();
    }
}

