/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.LinkedTreeMap;
import com.redhat.qute.settings.FaultTolerantTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EitherTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;

public class JSONUtility {
    private JSONUtility() {
    }

    public static <T> T toModel(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class can not be null");
        }
        if (object instanceof JsonElement) {
            Gson gson = JSONUtility.getDefaultGsonBuilder().create();
            return (T)gson.fromJson((JsonElement)object, clazz);
        }
        if (object instanceof LinkedTreeMap) {
            Gson gson = JSONUtility.getDefaultGsonBuilder().create();
            return (T)gson.fromJson(gson.toJson(object), clazz);
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        return null;
    }

    private static GsonBuilder getDefaultGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new EitherTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new FaultTolerantTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory());
    }
}

