/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.utils;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.RangeOffset;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;

public class QutePositionUtility {
    private static final Logger LOGGER = Logger.getLogger(QutePositionUtility.class.getName());

    public static Location toLocation(LocationLink locationLink) {
        return new Location(locationLink.getTargetUri(), locationLink.getTargetRange());
    }

    public static Range selectStartTagName(Section section) {
        return QutePositionUtility.selectStartTagName(section, false);
    }

    public static Range selectStartTagName(Section section, boolean includeCurly) {
        Template template = section.getOwnerTemplate();
        int startOffset = section.getStartTagNameOpenOffset() - (includeCurly ? 1 : 0);
        int endOffset = section.getStartTagNameCloseOffset();
        return QutePositionUtility.createRange(startOffset, endOffset, template);
    }

    public static Range selectEndTagName(Section sectionTag) {
        return QutePositionUtility.selectEndTagName(sectionTag, true);
    }

    public static Range selectEndTagName(Section sectionTag, boolean includeSlash) {
        Template template = sectionTag.getOwnerTemplate();
        int startOffset = sectionTag.getEndTagNameOpenOffset() + (includeSlash ? 0 : 1);
        int endOffset = sectionTag.getEndTagCloseOffset();
        return QutePositionUtility.createRange(startOffset, endOffset, template);
    }

    public static Range selectClassName(ParameterDeclaration parameter) {
        Template template = parameter.getOwnerTemplate();
        int startOffset = parameter.getClassNameStart();
        int endOffset = parameter.getClassNameEnd();
        return QutePositionUtility.createRange(startOffset, endOffset, template);
    }

    public static Range selectAlias(ParameterDeclaration parameter) {
        Template template = parameter.getOwnerTemplate();
        int startOffset = parameter.getAliasStart();
        int endOffset = parameter.getAliasEnd();
        return QutePositionUtility.createRange(startOffset, endOffset, template);
    }

    public static Range selectParameterName(Parameter parameter) {
        Template template = parameter.getOwnerTemplate();
        int startOffset = parameter.getStartName();
        int endOffset = parameter.getEndName() - (parameter.isOptional() ? 2 : 0);
        return QutePositionUtility.createRange(startOffset, endOffset, template);
    }

    public static Range createRange(Part part) {
        Template template = part.getOwnerTemplate();
        return QutePositionUtility.createRange(part.getStartName(), part.getEndName(), template);
    }

    public static Range createRange(Node node) {
        Template template = node.getOwnerTemplate();
        return QutePositionUtility.createRange(node.getStart(), node.getEnd(), template);
    }

    public static Range createRange(int startOffset, int endOffset, Template template) {
        try {
            return new Range(template.positionAt(startOffset), template.positionAt(endOffset));
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While creating Range the Offset was a BadLocation", e);
            return null;
        }
    }

    public static Range createRange(RangeOffset range, Template template) {
        return QutePositionUtility.createRange(range.getStart(), range.getEnd(), template);
    }

    public static Node findBestNode(int offset, Node node) {
        return QutePositionUtility.findBestNode(offset, node, false);
    }

    public static Node findBestNode(int offset, Node node, boolean includeAfterStartExpression) {
        switch (node.getKind()) {
            case Section: {
                Section section = (Section)node;
                if (!section.isInParameters(offset)) break;
                Expression expression = null;
                Parameter parameter = section.getParameterAtOffset(offset);
                if (parameter != null) {
                    if (parameter.isAfterAssign(offset)) {
                        return parameter;
                    }
                    if (parameter.hasValueAssigned() && !parameter.isInValue(offset)) {
                        return parameter;
                    }
                    if (!parameter.hasValueAssigned() && !parameter.canHaveExpression()) {
                        return parameter;
                    }
                    expression = parameter.getJavaTypeExpression();
                }
                if (expression == null) {
                    if (offset >= section.getEndTagOpenOffset() && offset <= section.getEndTagCloseOffset()) {
                        return section;
                    }
                    expression = section.getExpressionParameter();
                }
                if (expression == null) break;
                Node expressionNode = QutePositionUtility.findBestNode(expression, offset);
                if (expressionNode != null) {
                    return expressionNode;
                }
                return expression;
            }
            case Expression: {
                Expression expression = (Expression)node;
                boolean adjust = includeAfterStartExpression && expression.getStartContentOffset() == offset;
                return QutePositionUtility.findBestNode(expression, offset + (adjust ? 1 : 0));
            }
            default: {
                return node;
            }
        }
        return node;
    }

    private static Node findBestNode(Expression expression, int offset) {
        Node expressionNode = expression.findNodeExpressionAt(offset);
        if (expressionNode != null) {
            MethodPart method;
            Parameter parameter;
            if (expressionNode instanceof MethodPart && (parameter = (method = (MethodPart)expressionNode).getParameterAtOffset(offset)) != null) {
                Expression parameterExpression = parameter.getJavaTypeExpression();
                if (parameterExpression != null) {
                    return QutePositionUtility.findBestNode(parameterExpression, offset);
                }
                return parameter;
            }
            return expressionNode;
        }
        return expression;
    }

    public static Location createLocation(Node target) {
        Template targetDocument = target.getOwnerTemplate();
        Range targetRange = QutePositionUtility.createRange(target.getStart(), target.getEnd(), targetDocument);
        return new Location(targetDocument.getUri(), targetRange);
    }
}

