/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.utils;

import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.JavaTypeInfoProvider;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.ElseSection;
import com.redhat.qute.parser.template.sections.LoopSection;
import com.redhat.qute.parser.template.sections.WhenSection;
import com.redhat.qute.parser.template.sections.WithSection;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteSearchUtils {
    public static void searchDeclaredObject(ObjectPart part, BiConsumer<Node, Range> collector, boolean includeNode, CancelChecker cancelChecker) {
        String namespace;
        if (includeNode) {
            Range range = QutePositionUtility.createRange(part);
            collector.accept(part, range);
        }
        if ("data".equals(namespace = part.getNamespace())) {
            QuteSearchUtils.searchDeclaredObjectInParameterDeclaration(part, collector);
        } else {
            Parameter parameter = QuteSearchUtils.searchDeclaredObjectInParameter(part, cancelChecker);
            if (parameter != null) {
                Range targetRange = QutePositionUtility.selectParameterName(parameter);
                collector.accept(parameter, targetRange);
            } else {
                QuteSearchUtils.searchDeclaredObjectInParameterDeclaration(part, collector);
            }
        }
    }

    private static void searchDeclaredObjectInParameterDeclaration(ObjectPart part, BiConsumer<Node, Range> collector) {
        String partName = part.getPartName();
        ParameterDeclaration parameterDeclaration = part.getOwnerTemplate().findInParameterDeclarationByAlias(partName);
        if (parameterDeclaration != null) {
            Range targetRange = QutePositionUtility.selectAlias(parameterDeclaration);
            collector.accept(parameterDeclaration, targetRange);
        }
    }

    private static Parameter searchDeclaredObjectInParameter(ObjectPart part, CancelChecker cancelChecker) {
        String partName = part.getPartName();
        Parameter matchedOptionalParameter = null;
        block6: for (Node parent = part.getParentSection(); parent != null; parent = parent.getParent()) {
            if (((Node)parent).getKind() != NodeKind.Section) continue;
            Section section = parent;
            switch (section.getSectionKind()) {
                case EACH: 
                case FOR: {
                    String alias;
                    LoopSection iterableSection = (LoopSection)section;
                    if (iterableSection.isInElseBlock(part.getStart()) || !partName.equals(alias = iterableSection.getAlias()) && !section.isMetadata(partName)) continue block6;
                    return iterableSection.getAliasParameter();
                }
                case LET: 
                case SET: {
                    Parameter parameter;
                    List<Parameter> parameters = section.getParameters();
                    Iterator<Parameter> iterator = parameters.iterator();
                    while (iterator.hasNext()) {
                        parameter = iterator.next();
                        if (!partName.equals(parameter.getName())) continue;
                        return parameter;
                    }
                    continue block6;
                }
                case IF: {
                    Parameter parameter;
                    Iterator<Parameter> iterator;
                    List<Parameter> parameters;
                    if (matchedOptionalParameter != null || !(iterator = (parameters = section.getParameters()).iterator()).hasNext() || !partName.equals((parameter = iterator.next()).getName()) || !parameter.isOptional()) continue block6;
                    matchedOptionalParameter = parameter;
                    continue block6;
                }
                case CUSTOM: {
                    Parameter parameter;
                    List<Parameter> parameters = section.getParameters();
                    if (parameters == null) continue block6;
                    Iterator<Parameter> iterator = parameters.iterator();
                    while (iterator.hasNext()) {
                        parameter = iterator.next();
                        if (!parameter.canHaveExpression() || !partName.equals(parameter.getName())) continue;
                        return parameter;
                    }
                    continue block6;
                }
            }
        }
        return matchedOptionalParameter;
    }

    public static void searchReferencedObjects(Node node, int offset, BiConsumer<Node, Range> collector, boolean includeNode, CancelChecker cancelChecker) {
        switch (node.getKind()) {
            case ParameterDeclaration: {
                ParameterDeclaration parameterDeclaration = (ParameterDeclaration)node;
                if (parameterDeclaration.isInJavaTypeName(offset)) {
                    ParameterDeclaration.JavaTypeRangeOffset rangeOffset = parameterDeclaration.getJavaTypeNameRange(offset);
                    if (rangeOffset == null) break;
                    Range range = QutePositionUtility.createRange(rangeOffset, node.getOwnerTemplate());
                    collector.accept(parameterDeclaration, range);
                    break;
                }
                if (!parameterDeclaration.isInAlias(offset)) break;
                String alias = parameterDeclaration.getAlias();
                if (includeNode) {
                    Range range = QutePositionUtility.selectAlias(parameterDeclaration);
                    collector.accept(parameterDeclaration, range);
                }
                QuteSearchUtils.searchReferencedObjects(alias, PartNameMatcher.BOTH, node, collector, cancelChecker);
                break;
            }
            case Parameter: {
                Parameter parameter = (Parameter)node;
                if (includeNode) {
                    Range range = QutePositionUtility.selectParameterName(parameter);
                    collector.accept(parameter, range);
                }
                String alias = parameter.getName();
                QuteSearchUtils.searchReferencedObjects(alias, PartNameMatcher.ONLY_NAME, parameter.getParent(), collector, cancelChecker);
                break;
            }
            case ExpressionPart: {
                Parameter parameter;
                ObjectPart objectPart;
                Part part = (Part)node;
                if (part.getPartKind() != Parts.PartKind.Object || !(objectPart = (ObjectPart)part).isOptional() || (parameter = objectPart.getOwnerParameter()) == null || parameter.getOwnerSection() == null || parameter.getOwnerSection().getSectionKind() != SectionKind.IF) break;
                QuteSearchUtils.searchReferencedObjects(parameter, offset, collector, includeNode, cancelChecker);
            }
        }
    }

    private static void searchReferencedObjects(String partName, PartNameMatcher matcher, Node owerNode, BiConsumer<Node, Range> collector, CancelChecker cancelChecker) {
        Template template = owerNode.getOwnerTemplate();
        Node parent = owerNode.getKind() == NodeKind.ParameterDeclaration ? template : owerNode;
        QuteSearchUtils.searchReferencedObjects(partName, matcher, parent, owerNode, collector, cancelChecker);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void searchReferencedObjects(String partName, PartNameMatcher matcher, Node parent, Node ownerNode, BiConsumer<Node, Range> collector, CancelChecker cancelChecker) {
        Section section;
        if (parent != ownerNode) {
            switch (parent.getKind()) {
                case Expression: {
                    Expression expression = (Expression)parent;
                    QuteSearchUtils.tryToCollectObjectPartOrParameter(partName, matcher, expression, ownerNode, collector);
                    break;
                }
                case Section: {
                    section = (Section)parent;
                    switch (section.getSectionKind()) {
                        case EACH: 
                        case FOR: {
                            LoopSection iterableSection = (LoopSection)parent;
                            Iterator<Parameter> iterableParameter = iterableSection.getIterableParameter();
                            if (iterableParameter == null) break;
                            Expression parameterExpr = ((Parameter)((Object)iterableParameter)).getJavaTypeExpression();
                            QuteSearchUtils.tryToCollectObjectPartOrParameter(partName, matcher, parameterExpr, ownerNode, collector);
                            Parameter aliasParameter = iterableSection.getAliasParameter();
                            if (aliasParameter == null || !partName.equals(aliasParameter.getName())) break;
                            matcher = PartNameMatcher.ONLY_NAMESPACE;
                            break;
                        }
                        case LET: 
                        case SET: {
                            Expression parameterExpr;
                            List<Parameter> parameters = section.getParameters();
                            if (parameters == null) break;
                            for (Parameter parameter : parameters) {
                                if (!parameter.hasValueAssigned()) continue;
                                parameterExpr = parameter.getJavaTypeExpression();
                                QuteSearchUtils.tryToCollectObjectPartOrParameter(partName, matcher, parameterExpr, ownerNode, collector);
                            }
                            break;
                        }
                        case IF: {
                            Expression parameterExpr;
                            List<Parameter> parameters = section.getParameters();
                            if (parameters == null) break;
                            for (Parameter parameter : parameters) {
                                parameterExpr = parameter.getJavaTypeExpression();
                                QuteSearchUtils.tryToCollectObjectPartOrParameter(partName, matcher, parameterExpr, ownerNode, collector);
                            }
                            break;
                        }
                        case WITH: {
                            Parameter parameter = ((WithSection)section).getObjectParameter();
                            Object parameterExpr = parameter.getJavaTypeExpression();
                            QuteSearchUtils.tryToCollectObjectPartOrParameter(partName, matcher, (Expression)parameterExpr, ownerNode, collector);
                            break;
                        }
                        case WHEN: 
                        case SWITCH: {
                            Parameter parameter = ((WhenSection)section).getValueParameter();
                            Object parameterExpr = parameter.getJavaTypeExpression();
                            QuteSearchUtils.tryToCollectObjectPartOrParameter(partName, matcher, (Expression)parameterExpr, ownerNode, collector);
                            break;
                        }
                        case CUSTOM: {
                            Expression parameterExpr;
                            List<Parameter> parameters = section.getParameters();
                            if (parameters == null) break;
                            for (Parameter parameter : parameters) {
                                if (!parameter.canHaveExpression()) continue;
                                parameterExpr = parameter.getJavaTypeExpression();
                                QuteSearchUtils.tryToCollectObjectPartOrParameter(partName, matcher, parameterExpr, ownerNode, collector);
                            }
                        }
                    }
                    break;
                }
            }
        }
        ElseSection stopWhenNode = null;
        if (ownerNode.getKind() == NodeKind.Section && ((section = (Section)ownerNode).getSectionKind() == SectionKind.EACH || section.getSectionKind() == SectionKind.FOR)) {
            stopWhenNode = ((LoopSection)section).getElseSection();
        }
        List<Node> children = parent.getChildren();
        Iterator<Node> iterator = children.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (node == stopWhenNode) {
                return;
            }
            QuteSearchUtils.searchReferencedObjects(partName, matcher, node, ownerNode, collector, cancelChecker);
        }
    }

    public static void tryToCollectObjectPartOrParameter(String partName, PartNameMatcher matcher, Expression expression, Node ownerNode, BiConsumer<Node, Range> collector) {
        if (expression == null) {
            return;
        }
        if (!QuteSearchUtils.tryToCollectObjectParts(partName, matcher, expression, collector) && ownerNode.getKind() == NodeKind.Section) {
            JavaTypeInfoProvider metadata;
            Section onwerSection = (Section)ownerNode;
            ObjectPart objectPart = expression.getObjectPart();
            if (objectPart != null && (metadata = onwerSection.getMetadata(objectPart.getPartName())) != null) {
                Range range = QutePositionUtility.createRange(objectPart.getStart(), objectPart.getStart() + partName.length(), objectPart.getOwnerTemplate());
                collector.accept(objectPart, range);
            }
        }
    }

    private static boolean tryToCollectObjectParts(String partName, PartNameMatcher matcher, Node nodeExpr, BiConsumer<Node, Range> collector) {
        switch (nodeExpr.getKind()) {
            case Expression: {
                Expression expression = (Expression)nodeExpr;
                boolean result = false;
                List<Node> nodes = expression.getExpressionContent();
                for (Node node : nodes) {
                    result |= QuteSearchUtils.tryToCollectObjectParts(partName, matcher, node, collector);
                }
                return result;
            }
            case ExpressionParts: {
                Parts parts = (Parts)nodeExpr;
                boolean result = false;
                for (Node partNode : parts.getChildren()) {
                    result |= QuteSearchUtils.tryToCollectObjectParts(partName, matcher, partNode, collector);
                }
                return result;
            }
            case ExpressionPart: {
                Part part = (Part)nodeExpr;
                if (part.getPartKind() == Parts.PartKind.Object) {
                    ObjectPart objectPart = (ObjectPart)part;
                    if (!QuteSearchUtils.isMatch(objectPart, partName, matcher)) break;
                    Range range = QutePositionUtility.createRange(objectPart);
                    collector.accept(objectPart, range);
                    return true;
                }
                if (part.getPartKind() != Parts.PartKind.Method) break;
                MethodPart methodPart = (MethodPart)part;
                List<Parameter> parameters = methodPart.getParameters();
                boolean result = false;
                for (Parameter parameter : parameters) {
                    Expression paramExpr = parameter.getJavaTypeExpression();
                    if (paramExpr == null) continue;
                    result |= QuteSearchUtils.tryToCollectObjectParts(partName, matcher, paramExpr, collector);
                }
                return result;
            }
        }
        return false;
    }

    private static boolean isMatch(ObjectPart objectPart, String partName, PartNameMatcher matcher) {
        if (objectPart == null || !partName.equals(objectPart.getPartName())) {
            return false;
        }
        switch (matcher) {
            case BOTH: {
                return true;
            }
            case ONLY_NAME: {
                return objectPart.getNamespace() == null;
            }
            case ONLY_NAMESPACE: {
                return "data".equals(objectPart.getNamespace());
            }
        }
        return true;
    }

    private static enum PartNameMatcher {
        ONLY_NAME,
        ONLY_NAMESPACE,
        BOTH;

    }
}

