/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.utils;

import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionMetadata;
import com.redhat.qute.parser.template.Template;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class UserTagUtils {
    public static final String IT_OBJECT_PART_NAME = "it";
    public static final String NESTED_CONTENT_OBJECT_PART_NAME = "nested-content";
    private static final Map<String, SectionMetadata> SPECIAL_KEYS = new HashMap<String, SectionMetadata>();
    public static final String TAGS_DIR = "tags";

    private static void register(SectionMetadata metadata) {
        SPECIAL_KEYS.put(metadata.getName(), metadata);
    }

    public static boolean isUserTag(Template template) {
        String templateId = template.getTemplateId();
        return templateId != null && templateId.startsWith(TAGS_DIR);
    }

    public static String getTemplateId(String tagName) {
        return "tags/" + tagName;
    }

    public static String getUserTagName(String uri) {
        int index = uri.lastIndexOf(47);
        String fileName = index != -1 ? uri.substring(index + 1, uri.length()) : uri;
        return fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
    }

    public static void collectUserTagParameters(Template template, Consumer<ObjectPart> collector, CancelChecker cancelChecker) {
        UserTagUtils.collectUserTagParameters(template, template, new HashSet<String>(), collector, cancelChecker);
    }

    private static void collectUserTagParameters(Node parent, Template template, Set<String> extistingObjectParts, Consumer<ObjectPart> collector, CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        if (parent.getKind() == NodeKind.Expression) {
            Expression expression = (Expression)parent;
            UserTagUtils.collectUserTagParameters(expression, extistingObjectParts, collector, cancelChecker);
            return;
        }
        if (parent.getKind() == NodeKind.Section) {
            Section section = (Section)parent;
            List<Parameter> parameters = section.getParameters();
            for (Parameter parameter : parameters) {
                if (!parameter.canHaveExpression()) continue;
                Expression expression = parameter.getJavaTypeExpression();
                UserTagUtils.collectUserTagParameters(expression, extistingObjectParts, collector, cancelChecker);
            }
        }
        List<Node> children = parent.getChildren();
        for (Node node : children) {
            UserTagUtils.collectUserTagParameters(node, template, extistingObjectParts, collector, cancelChecker);
        }
    }

    private static void collectUserTagParameters(Expression expression, Set<String> extistingObjectParts, Consumer<ObjectPart> collector, CancelChecker cancelChecker) {
        String partName;
        ObjectPart objectPart = expression.getObjectPart();
        if (objectPart != null && expression.getNamespacePart() == null && !extistingObjectParts.contains(partName = objectPart.getPartName())) {
            extistingObjectParts.add(partName);
            collector.accept(objectPart);
        }
    }

    public static Collection<SectionMetadata> getSpecialKeys() {
        return SPECIAL_KEYS.values();
    }

    public static SectionMetadata getSpecialKey(String objectName) {
        return SPECIAL_KEYS.get(objectName);
    }

    static {
        UserTagUtils.register(new SectionMetadata(IT_OBJECT_PART_NAME, Object.class.getName(), "`it` is a special key that is replaced with the first unnamed parameter of the tag."));
        UserTagUtils.register(new SectionMetadata(NESTED_CONTENT_OBJECT_PART_NAME, Object.class.getName(), "`nested-content` is a special key that will be replaced by the content of the tag"));
    }
}

