/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata;

import com.redhat.rcm.maven.plugin.buildmetadata.AbstractBuildMojo;
import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmControl;
import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmCredentials;
import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.data.HostMetaDataProvider;
import com.redhat.rcm.maven.plugin.buildmetadata.data.MavenMetaDataProvider;
import com.redhat.rcm.maven.plugin.buildmetadata.data.MavenMetaDataSelection;
import com.redhat.rcm.maven.plugin.buildmetadata.data.ScmMetaDataProvider;
import com.redhat.rcm.maven.plugin.buildmetadata.io.BuildPropertiesFileHelper;
import com.redhat.rcm.maven.plugin.buildmetadata.io.BuildXmlFileHelper;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.ScmNoRevisionException;
import com.redhat.rcm.maven.plugin.buildmetadata.util.FilePathNormalizer;
import com.redhat.rcm.maven.plugin.buildmetadata.util.LoggingUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

public final class BuildMetaDataMojo
extends AbstractBuildMojo {
    private Settings settings;
    private boolean forceNewProperties;
    private boolean offline;
    private boolean addScmInfo;
    private boolean failOnMissingRevision;
    private boolean addHostInfo;
    private boolean addEnvInfo;
    private boolean addJavaRuntimeInfo;
    private boolean addOsInfo;
    private boolean addMavenExecutionInfo;
    private boolean addProjectInfo;
    private boolean hideCommandLineInfo;
    private boolean hideMavenOptsInfo;
    private boolean hideJavaOptsInfo;
    private boolean skip;
    private boolean validateCheckout;
    private String logLevel;
    private ScmManager scmManager;
    private String connectionType;
    protected String buildDatePattern = "dd.MM.yyyy";
    private String buildUserPropertyName;
    private boolean addBuildDateToFullVersion;
    private String scmDateFormat;
    private File basedir;
    private String userName;
    private String password;
    private String privateKey;
    private String passphrase;
    private String tagBase;
    private boolean addReleaseNumberToFullVersion;
    private boolean addLocallyModifiedTagToFullVersion;
    private int queryRangeInDays;
    private boolean failOnLocalModifications;
    private boolean ignoreDotFilesInBaseDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            super.execute();
            String baseDir = this.project.getBasedir().getAbsolutePath();
            FilePathNormalizer filePathNormalizer = new FilePathNormalizer(baseDir);
            BuildPropertiesFileHelper helper = new BuildPropertiesFileHelper(this.getLog(), this.propertiesOutputFile, filePathNormalizer);
            Properties projectProperties = helper.getProjectProperties(this.project);
            if (!this.isBuildPropertiesAlreadySet(projectProperties)) {
                LoggingUtils.configureLogger(this.getLog(), this.logLevel);
                Properties buildMetaDataProperties = new Properties();
                if (this.isBuildPropertiesToBeRebuild()) {
                    this.createBuildProperties(helper, projectProperties, buildMetaDataProperties);
                } else {
                    this.getLog().info((CharSequence)"Reusing previously built metadata file.");
                    helper.readBuildPropertiesFile(buildMetaDataProperties);
                }
                this.updateMavenEnvironment(buildMetaDataProperties, helper);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping buildmetadata collection since skip=true.");
        }
    }

    private void createBuildProperties(BuildPropertiesFileHelper helper, Properties projectProperties, Properties buildMetaDataProperties) throws MojoExecutionException, MojoFailureException {
        Date buildDate = this.session.getStartTime();
        this.provideBuildUser(projectProperties, buildMetaDataProperties);
        this.provideMavenMetaData(buildMetaDataProperties);
        this.provideHostMetaData(buildMetaDataProperties);
        ScmInfo scmInfo = this.provideScmMetaData(buildMetaDataProperties);
        this.provideBuildDateMetaData(buildMetaDataProperties, buildDate);
        this.provideBuildMetaData(buildMetaDataProperties, scmInfo, this.providers, false);
        this.writeBuildMetaData(helper, buildMetaDataProperties);
    }

    private void writeBuildMetaData(BuildPropertiesFileHelper helper, Properties buildMetaDataProperties) throws MojoExecutionException {
        helper.writePropertiesFile(buildMetaDataProperties);
        if (this.createXmlReport) {
            String projectRootPath = this.project.getBasedir().getAbsolutePath();
            BuildXmlFileHelper xmlHelper = new BuildXmlFileHelper(projectRootPath, this.getLog(), this.xmlOutputFile, this.properties);
            xmlHelper.writeXmlFile(buildMetaDataProperties);
        }
    }

    private void provideMavenMetaData(Properties buildMetaDataProperties) {
        MavenMetaDataSelection selection = new MavenMetaDataSelection();
        selection.setAddMavenExecutionInfo(this.addMavenExecutionInfo);
        selection.setAddEnvInfo(this.addEnvInfo);
        selection.setAddJavaRuntimeInfo(this.addJavaRuntimeInfo);
        selection.setAddOsInfo(this.addOsInfo);
        selection.setAddProjectInfo(this.addProjectInfo);
        selection.setHideCommandLineInfo(this.hideCommandLineInfo);
        selection.setHideJavaOptsInfo(this.hideJavaOptsInfo);
        selection.setHideMavenOptsInfo(this.hideMavenOptsInfo);
        selection.setSelectedSystemProperties(this.properties);
        MavenMetaDataProvider mavenMetaDataProvider = new MavenMetaDataProvider(this.project, this.session, this.runtime, selection);
        mavenMetaDataProvider.provideBuildMetaData(buildMetaDataProperties);
    }

    private ScmInfo provideScmMetaData(Properties buildMetaDataProperties) throws MojoFailureException {
        try {
            ScmInfo scmInfo = this.createScmInfo();
            ScmMetaDataProvider scmMetaDataProvider = new ScmMetaDataProvider(this.project, scmInfo);
            scmMetaDataProvider.provideBuildMetaData(buildMetaDataProperties);
            return scmInfo;
        }
        catch (ScmNoRevisionException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    private void provideHostMetaData(Properties buildMetaDataProperties) throws MojoExecutionException {
        if (this.addHostInfo) {
            HostMetaDataProvider hostMetaData = new HostMetaDataProvider();
            hostMetaData.provideBuildMetaData(buildMetaDataProperties);
        }
    }

    private void provideBuildDateMetaData(Properties buildMetaDataProperties, Date buildDate) {
        String buildDateString = this.createBuildDate(buildMetaDataProperties, buildDate);
        this.createYears(buildMetaDataProperties, buildDate);
        this.createBuildVersion(buildMetaDataProperties, buildDate, buildDateString);
    }

    private ScmInfo createScmInfo() {
        ScmCredentials scmCredentials = new ScmCredentials(this.settings, this.userName, this.password, this.privateKey, this.passphrase);
        ScmControl scmControl = new ScmControl(this.failOnLocalModifications, this.ignoreDotFilesInBaseDir, this.offline, this.addScmInfo, this.validateCheckout, this.failOnMissingRevision);
        ScmInfo scmInfo = new ScmInfo(this.scmManager, this.connectionType, this.scmDateFormat, this.basedir, scmCredentials, this.tagBase, this.queryRangeInDays, this.buildDatePattern, scmControl);
        return scmInfo;
    }

    private boolean isBuildPropertiesToBeRebuild() {
        return this.forceNewProperties || !this.propertiesOutputFile.exists();
    }

    private boolean isBuildPropertiesAlreadySet(Properties projectProperties) {
        return projectProperties.getProperty("build.version.full") != null;
    }

    private void provideBuildUser(Properties projectProperties, Properties buildMetaDataProperties) {
        String value;
        String userNameValue = System.getProperty("user.name");
        if (this.buildUserPropertyName != null && !StringUtils.isBlank((String)(value = projectProperties.getProperty(this.buildUserPropertyName)))) {
            userNameValue = value;
        }
        if (userNameValue != null) {
            buildMetaDataProperties.setProperty("build.user", userNameValue);
        }
    }

    private String createBuildDate(Properties buildMetaDataProperties, Date buildDate) {
        SimpleDateFormat format = new SimpleDateFormat(this.buildDatePattern, Locale.ENGLISH);
        String buildDateString = format.format(buildDate);
        String timestamp = String.valueOf(buildDate.getTime());
        buildMetaDataProperties.setProperty("build.date", buildDateString);
        buildMetaDataProperties.setProperty("build.date.pattern", this.buildDatePattern);
        buildMetaDataProperties.setProperty("build.timestamp.millis", timestamp);
        return buildDateString;
    }

    private void createYears(Properties buildMetaDataProperties, Date buildDate) {
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.ENGLISH);
        String buildYearString = yearFormat.format(buildDate);
        buildMetaDataProperties.setProperty("build.year", buildYearString);
        String inceptionYearString = this.project.getInceptionYear();
        String copyrightYearString = buildYearString.equals(inceptionYearString) ? inceptionYearString : inceptionYearString + '-' + buildYearString;
        buildMetaDataProperties.setProperty("build.copyright.year", copyrightYearString);
    }

    private void createBuildVersion(Properties buildMetaDataProperties, Date buildDate, String buildDateString) {
        String version = this.project.getVersion();
        buildMetaDataProperties.setProperty("build.version", version);
        buildMetaDataProperties.setProperty("build.groupId", this.project.getGroupId());
        buildMetaDataProperties.setProperty("build.artifactId", this.project.getArtifactId());
        buildMetaDataProperties.setProperty("build.date", buildDateString);
        String fullVersion = this.createFullVersion(buildMetaDataProperties, buildDate);
        buildMetaDataProperties.setProperty("build.version.full", fullVersion);
    }

    private String createFullVersion(Properties buildMetaDataProperties, Date buildDate) {
        String versionSuffix;
        String versionPrefix;
        String version = this.project.getVersion();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
        String datePart = format.format(buildDate);
        String revisionId = buildMetaDataProperties.getProperty("build.scmRevision.id");
        if (version.endsWith("-SNAPSHOT")) {
            versionPrefix = version.substring(0, version.lastIndexOf(45));
            versionSuffix = "-SNAPSHOT";
        } else {
            versionPrefix = version;
            versionSuffix = "";
        }
        String modified = this.addLocallyModifiedTagToFullVersion && "true".equals(buildMetaDataProperties.getProperty("build.scmLocallyModified")) ? "-locally-modified" : "";
        String fullVersion = versionPrefix + (this.addBuildDateToFullVersion ? '-' + datePart : "") + (this.addReleaseNumberToFullVersion && StringUtils.isNotBlank((String)revisionId) ? "r" + revisionId : "") + modified + versionSuffix;
        return fullVersion;
    }
}

