/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata;

import com.redhat.rcm.maven.plugin.buildmetadata.AbstractReportMojo;
import com.redhat.rcm.maven.plugin.buildmetadata.BuildReportRenderer;
import com.redhat.rcm.maven.plugin.buildmetadata.FileMapping;
import com.redhat.rcm.maven.plugin.buildmetadata.PropertyOutputFileMapper;
import com.redhat.rcm.maven.plugin.buildmetadata.common.Property;
import com.redhat.rcm.maven.plugin.buildmetadata.util.FilePathNormalizer;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.reporting.MavenReportException;

public final class BuildReportMojo
extends AbstractReportMojo {
    private File propertiesOutputFile;
    private boolean activatePropertyOutputFileMapping;
    protected List<FileMapping> propertyOutputFileMapping;
    protected List<Property> properties;
    protected boolean createPropertiesReport;

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.description");
    }

    public String getOutputName() {
        return "build-report";
    }

    public void execute() throws MojoExecutionException {
        this.init();
        super.execute();
    }

    protected void init() {
        if (this.propertiesOutputFile == null || !this.propertiesOutputFile.canRead()) {
            PropertyOutputFileMapper mapper = new PropertyOutputFileMapper(this.project, this.propertyOutputFileMapping, "build.properties");
            this.propertyOutputFileMapping = mapper.initOutputFileMapping();
            this.propertiesOutputFile = this.createPropertiesReport ? mapper.getPropertiesOutputFile(this.activatePropertyOutputFileMapping, this.propertiesOutputFile) : new File(this.project.getBuild().getDirectory(), "build.properties");
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        super.executeReport(locale);
        Sink sink = this.getSink();
        ResourceBundle messages = this.getBundle(locale);
        String baseDir = this.project.getBasedir().getAbsolutePath();
        BuildReportRenderer renderer = new BuildReportRenderer(new FilePathNormalizer(baseDir), messages, sink, this.propertiesOutputFile, this.properties);
        renderer.renderReport();
    }

    public boolean canGenerateReport() {
        this.init();
        return super.canGenerateReport() && this.propertiesOutputFile.canRead();
    }
}

