/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata;

import com.redhat.rcm.maven.plugin.buildmetadata.common.Constant;
import com.redhat.rcm.maven.plugin.buildmetadata.common.Property;
import com.redhat.rcm.maven.plugin.buildmetadata.util.FilePathNormalizer;
import com.redhat.rcm.maven.plugin.buildmetadata.util.NoopNormalizer;
import com.redhat.rcm.maven.plugin.buildmetadata.util.Normalizer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildReportRenderer {
    private final FilePathNormalizer filePathNormalizer;
    private final Sink sink;
    private final ResourceBundle messages;
    private final File buildMetaDataPropertiesFile;
    private final List<Property> properties;

    public BuildReportRenderer(FilePathNormalizer filePathNormalizer, ResourceBundle messages, Sink sink, File buildMetaDataPropertiesFile, List<Property> properties) {
        this.filePathNormalizer = filePathNormalizer;
        this.sink = sink;
        this.messages = messages;
        this.buildMetaDataPropertiesFile = buildMetaDataPropertiesFile;
        this.properties = properties;
    }

    public void renderReport() throws MavenReportException {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.messages.getString("report.name"));
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.renderBody();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    private void renderBody() throws MavenReportException {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.messages.getString("report.name"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.messages.getString("report.description"));
        this.sink.paragraph_();
        Properties buildMetaDataProperties = this.readBuildMetaDataProperties();
        this.renderSections(buildMetaDataProperties);
        this.renderFooter();
        this.sink.section1_();
    }

    private void renderSections(Properties buildMetaDataProperties) {
        for (Constant.Section section : Constant.REPORT_PROPERTIES) {
            List<String> properties = section.getProperties();
            if (!this.hasPropertiesProvided(buildMetaDataProperties, properties)) continue;
            String sectionKey = section.getTitleKey();
            this.sink.sectionTitle2();
            this.sink.text(this.messages.getString(sectionKey));
            this.sink.sectionTitle2_();
            this.renderTableStart();
            for (String key : properties) {
                this.renderCell(buildMetaDataProperties, key);
            }
            this.renderSelectedPropertiesForSection(buildMetaDataProperties, sectionKey);
            this.renderTableEnd();
        }
        this.renderNonStandardProperties(buildMetaDataProperties);
    }

    private boolean hasPropertiesProvided(Properties buildMetaDataProperties, List<String> properties) {
        for (String key : properties) {
            Object value = buildMetaDataProperties.get(key);
            if (value == null || !StringUtils.isNotBlank((String)String.valueOf(value))) continue;
            return true;
        }
        Set<String> selectedProperties = this.createSelectedProperties();
        for (String key : selectedProperties) {
            Object value = buildMetaDataProperties.get(key);
            if (value == null || !StringUtils.isNotBlank((String)String.valueOf(value))) continue;
            return true;
        }
        return false;
    }

    private void renderSelectedPropertiesForSection(Properties buildMetaDataProperties, String sectionKey) {
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Property property : this.properties) {
                if (!sectionKey.equals(property.getSection())) continue;
                String key = property.getName();
                this.renderCell(buildMetaDataProperties, key);
            }
        }
    }

    private void renderNonStandardProperties(Properties buildMetaDataProperties) {
        Properties nonStandardProperties = Constant.calcNonStandardProperties(buildMetaDataProperties, this.properties);
        if (!nonStandardProperties.isEmpty()) {
            this.sink.sectionTitle2();
            this.sink.text(this.messages.getString("build.misc"));
            this.sink.sectionTitle2_();
            this.renderTableStart();
            Enumeration<Object> en = nonStandardProperties.keys();
            while (en.hasMoreElements()) {
                String key = String.valueOf(en.nextElement());
                if (!Constant.isIntendedForMiscSection(key)) continue;
                this.renderCell(nonStandardProperties, key);
            }
            this.renderTableEnd();
        }
    }

    private Set<String> createSelectedProperties() {
        HashSet<String> selectedProperties = new HashSet<String>();
        if (this.properties != null) {
            for (Property property : this.properties) {
                selectedProperties.add(property.getName());
            }
        }
        return selectedProperties;
    }

    private void renderTableEnd() {
        this.sink.table_();
    }

    private void renderTableStart() {
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell("200");
        String topicLabel = this.messages.getString("report.table.header.topic");
        this.sink.text(topicLabel);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        String valueLabel = this.messages.getString("report.table.header.value");
        this.sink.text(valueLabel);
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
    }

    private void renderCell(Properties buildMetaDataProperties, String key) {
        Object value = buildMetaDataProperties.get(key);
        if (value != null) {
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(this.getLabel(key));
            this.sink.tableCell_();
            this.sink.tableCell();
            if ("build.maven.execution.profiles.active".equals(key)) {
                this.renderMultiTupleValue(buildMetaDataProperties, value, "build.maven.execution.profile.active");
            } else if ("build.scmLocallyModified.files".equals(key)) {
                String filesValue = Constant.prettifyFilesValue(value);
                this.renderMultiValue(filesValue, NoopNormalizer.INSTANCE);
            } else if ("build.maven.execution.goals".equals(key)) {
                this.renderMultiValue(value, NoopNormalizer.INSTANCE);
            } else if ("build.maven.execution.filters".equals(key)) {
                this.renderMultiValue(value, this.filePathNormalizer);
            } else {
                this.renderSingleValue(value);
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
    }

    private void renderSingleValue(Object value) {
        String stringValue = String.valueOf(value);
        if (stringValue != null && !this.isLink(stringValue)) {
            this.sink.text(stringValue);
        } else {
            this.sink.link(stringValue);
            this.sink.text(stringValue);
            this.sink.link_();
        }
    }

    private boolean isLink(String input) {
        return input.startsWith("http://") || input.startsWith("https://");
    }

    private void renderMultiTupleValue(Properties buildMetaDataProperties, Object value, String subKeyPrefix) {
        String stringValue = Constant.prettify((String)value);
        if (this.hasMultipleValues(stringValue)) {
            StringTokenizer tokenizer = new StringTokenizer(stringValue, ",");
            this.sink.numberedList(0);
            while (tokenizer.hasMoreTokens()) {
                String profileName = tokenizer.nextToken().trim();
                String subKey = subKeyPrefix + '.' + profileName;
                Object subValue = buildMetaDataProperties.get(subKey);
                String item = profileName + ':' + subValue;
                this.sink.listItem();
                this.sink.text(item);
                this.sink.listItem_();
            }
            this.sink.numberedList_();
        } else {
            this.sink.text(String.valueOf(value));
        }
    }

    private void renderMultiValue(Object value, Normalizer normalizer) {
        String stringValue = Constant.prettify(ObjectUtils.toString((Object)value));
        if (this.hasMultipleValues(stringValue)) {
            StringTokenizer tokenizer = new StringTokenizer(stringValue, ",");
            this.sink.numberedList(0);
            while (tokenizer.hasMoreTokens()) {
                String subValue = tokenizer.nextToken().trim();
                String textValue = normalizer.normalize(subValue);
                this.sink.listItem();
                this.sink.text(textValue);
                this.sink.listItem_();
            }
            this.sink.numberedList_();
        } else {
            String textValue = normalizer.normalize(stringValue);
            this.sink.text(textValue);
        }
    }

    private boolean hasMultipleValues(String stringValue) {
        return stringValue.indexOf(44) != -1;
    }

    private String getLabel(String key) {
        try {
            return this.messages.getString(key);
        }
        catch (MissingResourceException e) {
            if (this.properties != null) {
                for (Property property : this.properties) {
                    String label = property.getLabel();
                    if (!StringUtils.isNotBlank((String)label) || !key.equals(property.getMappedName())) continue;
                    return label;
                }
            }
            return key;
        }
    }

    private void renderFooter() {
        String footerText = this.messages.getString("report.footer");
        if (StringUtils.isNotBlank((String)footerText)) {
            this.sink.rawText(footerText);
        }
    }

    private Properties readBuildMetaDataProperties() throws MavenReportException {
        Properties buildMetaDataProperties = new Properties();
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(this.buildMetaDataPropertiesFile));
            buildMetaDataProperties.load(inStream);
        }
        catch (IOException e) {
            try {
                throw new MavenReportException("Cannot read build properties file '" + this.buildMetaDataPropertiesFile + "'.", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(inStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inStream);
        return buildMetaDataProperties;
    }
}

