/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.scm.maven;

import com.redhat.rcm.maven.plugin.buildmetadata.scm.LocallyModifiedInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.Revision;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.RevisionNumberFetcher;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.ScmException;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.MavenRevision;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.ScmAccessInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.ScmConnectionInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.StringRevision;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenScmRevisionNumberFetcher
implements RevisionNumberFetcher {
    private static final Log LOG = LogFactory.getLog(MavenScmRevisionNumberFetcher.class);
    private final ScmManager scmManager;
    private final ScmConnectionInfo scmConnectionInfo;
    private final ScmAccessInfo scmAccessInfo;

    public MavenScmRevisionNumberFetcher(ScmManager scmManager, ScmConnectionInfo scmConnectionInfo, ScmAccessInfo scmAccessInfo) {
        this.scmManager = scmManager;
        this.scmConnectionInfo = scmConnectionInfo;
        this.scmAccessInfo = scmAccessInfo;
    }

    @Override
    public Revision fetchLatestRevisionNumber() throws ScmException {
        ScmProvider provider;
        ScmRepository repository;
        ChangeLogScmResult result;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("  Fetching latest revision number.\n    " + this.scmConnectionInfo + "\n    " + this.scmAccessInfo));
        }
        if ((result = this.scmAccessInfo.fetchChangeLog(repository = this.scmConnectionInfo.createRepository(this.scmManager), provider = this.createScmProvider(repository))) != null) {
            ChangeLogSet changeLogSet = result.getChangeLog();
            Revision revision = this.findEndVersion(changeLogSet);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  Found revision '" + revision + "'."));
            }
            return revision;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"  No revision information found.");
        }
        return null;
    }

    @Override
    public LocallyModifiedInfo containsModifications(ScmFileSet fileSet) throws ScmException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("  Fetching modification information.\n    " + this.scmConnectionInfo + "\n    " + this.scmAccessInfo));
        }
        try {
            ScmRepository repository = this.scmConnectionInfo.createRepository(this.scmManager);
            ScmProvider provider = this.createScmProvider(repository);
            StatusScmResult result = provider.status(repository, fileSet);
            if (result.isSuccess()) {
                return this.createLocallyModifiedInfo(result);
            }
            String message = result.getProviderMessage() + ": " + result.getCommandOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message);
            }
            throw new ScmException(message);
        }
        catch (org.apache.maven.scm.ScmException e) {
            throw new ScmException(e);
        }
    }

    private LocallyModifiedInfo createLocallyModifiedInfo(StatusScmResult result) {
        boolean locallyModified;
        List<ScmFile> changedFiles = this.filter(result.getChangedFiles());
        boolean bl = locallyModified = !changedFiles.isEmpty();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("  Modifications have" + (locallyModified ? "" : " not") + " been found."));
        }
        return new LocallyModifiedInfo(locallyModified, locallyModified ? this.toString(changedFiles) : null);
    }

    private List<ScmFile> filter(List<ScmFile> files) {
        if (this.scmAccessInfo.isIgnoreDotFilesInBaseDir()) {
            this.filterDotFiles(files);
        }
        return files;
    }

    private void filterDotFiles(List<ScmFile> files) {
        Iterator<ScmFile> i = files.iterator();
        while (i.hasNext()) {
            ScmFile file = i.next();
            String path = file.getPath();
            if (path.length() <= 0 || path.charAt(0) != '.') continue;
            i.remove();
        }
    }

    private String toString(List<?> items) {
        StringBuilder buffer = new StringBuilder(512);
        for (Object item : items) {
            buffer.append(item).append(' ');
        }
        return StringUtils.chomp((String)buffer.toString());
    }

    private Revision findEndVersion(ChangeLogSet changeLogSet) {
        if (changeLogSet != null) {
            ScmVersion endVersion = changeLogSet.getEndVersion();
            if (endVersion != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"End version found.");
                }
                return new MavenRevision(endVersion, changeLogSet.getEndDate());
            }
            List changeSets = changeLogSet.getChangeSets();
            if (!changeSets.isEmpty()) {
                int lastIndex;
                for (int index = lastIndex = changeSets.size() - 1; index >= 0; --index) {
                    ChangeSet set = (ChangeSet)changeSets.get(lastIndex);
                    List changeFiles = set.getFiles();
                    if (!changeFiles.isEmpty()) {
                        ChangeFile file = (ChangeFile)changeFiles.get(0);
                        String revision = file.getRevision();
                        if (revision == null) continue;
                        return new StringRevision(revision, set.getDate());
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"No change files found.");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No change set found.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No change log set found.");
        }
        return null;
    }

    private ScmProvider createScmProvider(ScmRepository repository) throws ScmException {
        try {
            ScmProvider provider = this.scmManager.getProviderByRepository(repository);
            return provider;
        }
        catch (NoSuchScmProviderException e) {
            throw new ScmException("Cannot create SCM provider.", e);
        }
    }
}

