/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.util;

import com.redhat.rcm.maven.plugin.buildmetadata.util.SunLoggerConfigurator;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.apache.maven.plugin.logging.Log;

public final class LoggingUtils {
    private LoggingUtils() {
    }

    public static void configureLogger(Log log, String logLevel) throws NullPointerException {
        String newLevel;
        if (!LoggingUtils.isBlank(logLevel)) {
            newLevel = logLevel;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Using configured level " + newLevel));
            }
        } else {
            newLevel = LoggingUtils.determineLevel(log);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Using Maven level " + newLevel));
            }
        }
        LoggingUtils.configure(log, newLevel);
    }

    private static void configure(Log log, String newLevel) {
        if (LoggingUtils.isAvailable("org.apache.log4j.Logger")) {
            LoggingUtils.runLog4jConfigure(log, newLevel);
        }
        new SunLoggerConfigurator().configure(log, newLevel);
    }

    private static void runLog4jConfigure(Log log, String newLevel) {
        block2: {
            try {
                Class<?> clazz = Class.forName("com.redhat.rcm.maven.util.log4j.Log4jConfigurator");
                Object instance = clazz.newInstance();
                Method method = clazz.getMethod("configure", Log.class, String.class);
                method.invoke(instance, log, newLevel);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((CharSequence)"Cannot configure log4j logger.", (Throwable)e);
            }
        }
    }

    private static boolean isAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isBlank(String logLevel) {
        return logLevel == null || "".equals(logLevel.trim());
    }

    private static String determineLevel(Log log) {
        if (log.isDebugEnabled()) {
            return Level.FINEST.toString();
        }
        if (log.isInfoEnabled()) {
            return Level.INFO.toString();
        }
        if (log.isWarnEnabled()) {
            return Level.WARNING.toString();
        }
        return Level.SEVERE.toString();
    }
}

